/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.javaintegration.pojo;

import java.util.ArrayList;
import java.util.List;
import org.metafacture.javaintegration.pojo.TypeEncoder;
import org.metafacture.javaintegration.pojo.ValueType;

class ListTypeEncoder
implements TypeEncoder {
    private final ValueType valueType;
    private final List<Object> objects;

    ListTypeEncoder(ValueType valueType) {
        this.valueType = valueType;
        this.objects = new ArrayList<Object>();
    }

    static boolean supportsType(Class<?> clazz) {
        return List.class.isAssignableFrom(clazz);
    }

    @Override
    public void setValue(String name, Object value) {
        this.objects.add(value);
    }

    @Override
    public ValueType getValueType(String name) {
        return new ValueType(this.valueType.getElementClass());
    }

    @Override
    public Object getInstance() {
        return this.objects;
    }
}

