/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.javaintegration.pojo;

import java.util.HashMap;
import java.util.Map;
import org.metafacture.javaintegration.pojo.TypeEncoder;
import org.metafacture.javaintegration.pojo.ValueType;

class MapTypeEncoder
implements TypeEncoder {
    private final ValueType valueType;
    private final Map<String, Object> objectMap;

    MapTypeEncoder(ValueType valueType) {
        this.valueType = valueType;
        this.objectMap = new HashMap<String, Object>();
    }

    static boolean supportsType(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    @Override
    public void setValue(String name, Object value) {
        this.objectMap.put(name, value);
    }

    @Override
    public ValueType getValueType(String name) {
        return new ValueType(this.valueType.getElementClass());
    }

    @Override
    public Object getInstance() {
        return this.objectMap;
    }
}

