/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.javaintegration.pojo;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayDeque;
import java.util.Deque;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;
import org.metafacture.javaintegration.pojo.ComplexTypeEncoder;
import org.metafacture.javaintegration.pojo.TypeEncoder;
import org.metafacture.javaintegration.pojo.TypeEncoderFactory;
import org.metafacture.javaintegration.pojo.ValueType;

@Description(value="Creates a pojo (Plain Old Java Object) based on a record containing the member values")
@In(value=StreamReceiver.class)
@Out(value=Object.class)
@FluxCommand(value="encode-pojo")
public class PojoEncoder<T>
extends DefaultStreamPipe<ObjectReceiver<T>> {
    private final TypeEncoderFactory typeEncoderFactory = new TypeEncoderFactory();
    private final Deque<TypeEncoder> typeEncoderStack = new ArrayDeque<TypeEncoder>();
    private final Class<T> pojoClass;

    public PojoEncoder(Class<T> pojoClass) {
        this.pojoClass = pojoClass;
    }

    public void startRecord(String identifier) {
        this.typeEncoderStack.clear();
        this.typeEncoderStack.push(new ComplexTypeEncoder(this.pojoClass));
    }

    public void endRecord() {
        assert (this.typeEncoderStack.size() == 1);
        Object instance = this.typeEncoderStack.peek().getInstance();
        ((ObjectReceiver)this.getReceiver()).process(instance);
        this.typeEncoderStack.clear();
    }

    public void startEntity(String name) {
        TypeEncoder currentTypeEncoder = this.typeEncoderStack.peek();
        ValueType newType = currentTypeEncoder.getValueType(name);
        TypeEncoder newTypeEncoder = this.typeEncoderFactory.create(newType);
        currentTypeEncoder.setValue(name, newTypeEncoder.getInstance());
        this.typeEncoderStack.push(newTypeEncoder);
    }

    public void endEntity() {
        this.typeEncoderStack.pop();
    }

    public void literal(String name, String value) {
        TypeEncoder currentTypeEncoder = this.typeEncoderStack.peek();
        Class<?> targetType = currentTypeEncoder.getValueType(name).getRawClass();
        currentTypeEncoder.setValue(name, PojoEncoder.createObjectFromString(value, targetType));
    }

    private static Object createObjectFromString(String value, Class<?> targetType) {
        PropertyEditor propertyEditor = PropertyEditorManager.findEditor(targetType);
        propertyEditor.setAsText(value);
        return propertyEditor.getValue();
    }

    protected void onCloseStream() {
        this.typeEncoderStack.clear();
    }

    protected void onResetStream() {
        this.typeEncoderStack.clear();
    }

    static {
        PropertyEditorManager.registerEditor(Boolean.class, PropertyEditorManager.findEditor(Boolean.TYPE).getClass());
        PropertyEditorManager.registerEditor(Integer.class, PropertyEditorManager.findEditor(Integer.TYPE).getClass());
        PropertyEditorManager.registerEditor(Long.class, PropertyEditorManager.findEditor(Long.TYPE).getClass());
    }
}

