/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.jdom;

import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.output.SAXOutputter;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.ObjectPipe;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.XmlPipe;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;

@In(value=Document.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="from-jdom-document")
public final class JDomDocumentToStream
implements ObjectPipe<Document, StreamReceiver> {
    private final SAXOutputter saxOutputer;
    private final XmlPipe<StreamReceiver> xmlPipe;

    public JDomDocumentToStream(XmlPipe<StreamReceiver> xmlPipe) {
        this.xmlPipe = xmlPipe;
        this.saxOutputer = new SAXOutputter(xmlPipe);
    }

    public void process(Document document) {
        assert (null != document);
        try {
            this.saxOutputer.output(document);
        }
        catch (JDOMException e) {
            throw new IllegalArgumentException("Invalid JDOM document", e);
        }
    }

    public void resetStream() {
        this.xmlPipe.resetStream();
    }

    public void closeStream() {
        this.xmlPipe.closeStream();
    }

    public <R extends StreamReceiver> R setReceiver(R receiver) {
        return (R)((StreamReceiver)this.xmlPipe.setReceiver(receiver));
    }
}

