/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.jdom;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.metafacture.commons.ResourceUtil;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;

@Description(value="Converts a stream into a JDom document.")
@In(value=StreamReceiver.class)
@Out(value=Document.class)
@FluxCommand(value="to-jdom-document")
public final class StreamToJDomDocument
extends DefaultStreamPipe<ObjectReceiver<Document>> {
    private static final String ATTRIBUTE_MARKER = "~";
    private static final Pattern NAMESPACE_DELIMITER = Pattern.compile(":", 16);
    private static final String XML = "xml";
    private Document document;
    private Element currentElement;
    private final String rootTagName;
    private final Map<String, Namespace> namespaces = new HashMap<String, Namespace>();

    public StreamToJDomDocument(String rootTagName, String namespaceProperties) {
        Properties properties;
        this.rootTagName = rootTagName;
        this.namespaces.put(XML, Namespace.getNamespace((String)XML, (String)"http://www.w3.org/XML/1998/namespace"));
        try {
            properties = ResourceUtil.loadProperties((String)namespaceProperties);
        }
        catch (IOException e) {
            throw new MetafactureException("Cannot load namespaces list", (Throwable)e);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.namespaces.put(entry.getKey().toString(), Namespace.getNamespace((String)entry.getKey().toString(), (String)entry.getValue().toString()));
        }
    }

    public void startRecord(String identifier) {
        assert (!this.isClosed());
        this.currentElement = this.createElement(this.rootTagName);
        for (Namespace namespace : this.namespaces.values()) {
            this.currentElement.addNamespaceDeclaration(namespace);
        }
        this.document = new Document(this.currentElement);
    }

    public void startEntity(String name) {
        assert (!this.isClosed());
        Element parent = this.currentElement;
        this.currentElement = this.createElement(name);
        parent.addContent((Content)this.currentElement);
    }

    private Element createElement(String name) {
        String[] parts = NAMESPACE_DELIMITER.split(name);
        if (parts.length == 2) {
            return new Element(parts[1], this.getNamespace(parts[0]));
        }
        return new Element(name);
    }

    private Namespace getNamespace(String name) {
        Namespace namespace = this.namespaces.get(name);
        if (namespace == null) {
            throw new IllegalArgumentException("Namespace " + name + " not registered");
        }
        return namespace;
    }

    public void endEntity() {
        assert (!this.isClosed());
        this.currentElement = this.currentElement.getParentElement();
    }

    public void literal(String name, String value) {
        assert (!this.isClosed());
        if (name.isEmpty()) {
            this.currentElement.addContent(value);
        } else if (name.startsWith(ATTRIBUTE_MARKER)) {
            String[] parts = NAMESPACE_DELIMITER.split(name);
            if (parts.length == 2) {
                this.currentElement.setAttribute(parts[1], value, this.getNamespace(parts[0].substring(1)));
            } else {
                this.currentElement.setAttribute(name.substring(1), value);
            }
        } else {
            Element temp = this.createElement(name);
            this.currentElement.addContent((Content)temp);
            temp.setText(value);
        }
    }

    public void endRecord() {
        assert (!this.isClosed());
        ((ObjectReceiver)this.getReceiver()).process((Object)this.document);
    }
}

