/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.mangling;

import org.metafacture.flowcontrol.StreamBuffer;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;
import org.metafacture.mangling.EntityPathTracker;

@Description(value="By default changes the record ID to the value of the '_id' literal (if present). Use the contructor to choose another literal as ID source.")
@In(value=StreamReceiver.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="change-id")
public final class RecordIdChanger
extends DefaultStreamPipe<StreamReceiver> {
    private final StreamBuffer streamBuffer = new StreamBuffer();
    private final EntityPathTracker entityPathTracker = new EntityPathTracker();
    private String idLiteral = "_id";
    private String currentIdentifier;
    private String originalIdentifier;
    private boolean keepRecordsWithoutIdLiteral = true;
    private boolean keepIdLiteral;

    public void setIdLiteral(String idLiteral) {
        this.idLiteral = idLiteral;
    }

    public String getIdLiteral() {
        return this.idLiteral;
    }

    public void setKeepRecordsWithoutIdLiteral(boolean keepRecordsWithoutIdLiteral) {
        this.keepRecordsWithoutIdLiteral = keepRecordsWithoutIdLiteral;
    }

    public boolean getKeepRecordsWithoutIdLiteral() {
        return this.keepRecordsWithoutIdLiteral;
    }

    public void setKeepIdLiteral(boolean keepIdLiteral) {
        this.keepIdLiteral = keepIdLiteral;
    }

    public boolean getKeepIdLiteral() {
        return this.keepIdLiteral;
    }

    public void startRecord(String identifier) {
        assert (!this.isClosed());
        this.currentIdentifier = null;
        this.originalIdentifier = identifier;
        this.entityPathTracker.startRecord(identifier);
    }

    public void endRecord() {
        assert (!this.isClosed());
        if (this.currentIdentifier != null || this.keepRecordsWithoutIdLiteral) {
            if (this.currentIdentifier == null) {
                ((StreamReceiver)this.getReceiver()).startRecord(this.originalIdentifier);
            } else {
                ((StreamReceiver)this.getReceiver()).startRecord(this.currentIdentifier);
            }
            this.streamBuffer.replay();
            ((StreamReceiver)this.getReceiver()).endRecord();
        }
        this.streamBuffer.clear();
        this.entityPathTracker.endRecord();
    }

    public void startEntity(String name) {
        this.streamBuffer.startEntity(name);
        this.entityPathTracker.startEntity(name);
    }

    public void endEntity() {
        this.streamBuffer.endEntity();
        this.entityPathTracker.endEntity();
    }

    public void literal(String name, String value) {
        String qualifiedName = this.entityPathTracker.getCurrentPathWith(name);
        if (this.idLiteral.equals(qualifiedName)) {
            this.currentIdentifier = value;
            if (!this.keepIdLiteral) {
                return;
            }
        }
        this.streamBuffer.literal(name, value);
    }

    public void onSetReceiver() {
        this.streamBuffer.setReceiver(this.getReceiver());
    }

    public void onResetStream() {
        this.streamBuffer.clear();
        this.entityPathTracker.resetStream();
    }

    public void onCloseStream() {
        this.streamBuffer.clear();
        this.entityPathTracker.closeStream();
    }
}

