/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.mangling;

import java.util.EnumSet;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamPipe;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;

@In(value=StreamReceiver.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="discard-events")
public class StreamEventDiscarder
implements StreamPipe<StreamReceiver> {
    private StreamReceiver receiver;
    private EnumSet<EventType> discardedEvents = EnumSet.noneOf(EventType.class);

    public <R extends StreamReceiver> R setReceiver(R newReceiver) {
        this.receiver = newReceiver;
        return newReceiver;
    }

    public void setDiscardRecordEvents(boolean discard) {
        this.setDiscardEventsByType(EventType.RECORD, discard);
    }

    public void setDiscardEntityEvents(boolean discard) {
        this.setDiscardEventsByType(EventType.ENTITY, discard);
    }

    public void setDiscardLiteralEvents(boolean discard) {
        this.setDiscardEventsByType(EventType.LITERAL, discard);
    }

    public void setDiscardLifecycleEvents(boolean discard) {
        this.setDiscardEventsByType(EventType.RESET_STREAM, discard);
        this.setDiscardEventsByType(EventType.CLOSE_STREAM, discard);
    }

    private void setDiscardEventsByType(EventType type, boolean discard) {
        if (discard) {
            this.discardedEvents.add(type);
        } else {
            this.discardedEvents.remove((Object)type);
        }
    }

    public EnumSet<EventType> getDiscardedEvents() {
        return EnumSet.copyOf(this.discardedEvents);
    }

    public void setDiscardedEvents(EnumSet<EventType> discardedEvents) {
        this.discardedEvents = EnumSet.copyOf(discardedEvents);
    }

    public void startRecord(String identifier) {
        if (!this.discardedEvents.contains((Object)EventType.RECORD)) {
            this.receiver.startRecord(identifier);
        }
    }

    public void endRecord() {
        if (!this.discardedEvents.contains((Object)EventType.RECORD)) {
            this.receiver.endRecord();
        }
    }

    public void startEntity(String name) {
        if (!this.discardedEvents.contains((Object)EventType.ENTITY)) {
            this.receiver.startEntity(name);
        }
    }

    public void endEntity() {
        if (!this.discardedEvents.contains((Object)EventType.ENTITY)) {
            this.receiver.endEntity();
        }
    }

    public void literal(String name, String value) {
        if (!this.discardedEvents.contains((Object)EventType.LITERAL)) {
            this.receiver.literal(name, value);
        }
    }

    public void resetStream() {
        if (!this.discardedEvents.contains((Object)EventType.RESET_STREAM)) {
            this.receiver.resetStream();
        }
    }

    public void closeStream() {
        if (!this.discardedEvents.contains((Object)EventType.CLOSE_STREAM)) {
            this.receiver.closeStream();
        }
    }

    public static enum EventType {
        RECORD,
        ENTITY,
        LITERAL,
        RESET_STREAM,
        CLOSE_STREAM;

    }
}

