/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.mangling;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;

@Description(value="Emits literal values as objects.")
@In(value=StreamReceiver.class)
@Out(value=String.class)
@FluxCommand(value="literal-to-object")
public final class LiteralToObject
extends DefaultStreamPipe<ObjectReceiver<String>> {
    public static final String DEFAULT_PATTERN = ".*";
    private Matcher matcher = Pattern.compile(".*").matcher("");

    public void setPattern(String pattern) {
        this.matcher = Pattern.compile(pattern).matcher("");
    }

    public String getPattern() {
        return this.matcher.pattern().pattern();
    }

    public void literal(String name, String value) {
        assert (!this.isClosed());
        this.matcher.reset(name);
        if (this.matcher.matches()) {
            ((ObjectReceiver)this.getReceiver()).process((Object)value);
        }
    }
}

