/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.mangling;

import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;

@Description(value="Outputs a record containing the input object as literal")
@Out(value=StreamReceiver.class)
@FluxCommand(value="object-to-literal")
public final class ObjectToLiteral<T>
extends DefaultObjectPipe<T, StreamReceiver> {
    public static final String DEFAULT_LITERAL_NAME = "obj";
    public static final String DEFAULT_RECORD_ID = "";
    private String literalName = "obj";
    private String recordId = "";
    private int recordCount;

    public void setLiteralName(String literalName) {
        this.literalName = literalName;
    }

    public void setRecordId(String recordId) {
        this.recordId = recordId;
    }

    public String getLiteralName() {
        return this.literalName;
    }

    public String getRecordId() {
        return this.recordId;
    }

    public void process(T obj) {
        assert (obj != null);
        assert (!this.isClosed());
        ((StreamReceiver)this.getReceiver()).startRecord(String.format(this.recordId, ++this.recordCount));
        ((StreamReceiver)this.getReceiver()).literal(this.literalName, obj.toString());
        ((StreamReceiver)this.getReceiver()).endRecord();
    }
}

