/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.mangling;

import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;
import org.metafacture.mangling.EntityPathTracker;

@Description(value="Splits a stream into records based on entity path")
@In(value=StreamReceiver.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="filter-records-by-path")
public final class RecordPathFilter
extends DefaultStreamPipe<StreamReceiver> {
    public static final String DEFAULT_RECORD_ID_FORMAT = "%s[%d]";
    public static final String ROOT_PATH = "";
    private final EntityPathTracker entityPathTracker = new EntityPathTracker();
    private String path = "";
    private String recordIdFormat = "%s[%d]";
    private String recordIdentifier;
    private boolean inMatch;
    private boolean recordStarted;
    private int recordCount;

    public RecordPathFilter() {
    }

    public RecordPathFilter(String path) {
        this.setPath(path);
    }

    public void setEntitySeparator(String entitySeparator) {
        this.entityPathTracker.setEntitySeparator(entitySeparator);
    }

    public String getEntitySeparator() {
        return this.entityPathTracker.getEntitySeparator();
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setRecordIdFormat(String recordIdFormat) {
        this.recordIdFormat = recordIdFormat;
    }

    public String getRecordIdFormat() {
        return this.recordIdFormat;
    }

    public void startRecord(String identifier) {
        assert (!this.isClosed());
        this.recordCount = 0;
        this.recordIdentifier = identifier;
        this.entityPathTracker.startRecord(identifier);
    }

    public void endRecord() {
        assert (!this.isClosed());
        this.endRecordIfNeeded();
        this.entityPathTracker.endRecord();
    }

    public void startEntity(String name) {
        this.entityPathTracker.startEntity(name);
        if (this.inMatch()) {
            this.startRecordIfNeeded();
            ((StreamReceiver)this.getReceiver()).startEntity(name);
        } else if (this.pathMatching()) {
            this.inMatch = true;
        }
    }

    public void endEntity() {
        if (this.pathMatching()) {
            this.endRecordIfNeeded();
            this.inMatch = false;
        } else if (this.inMatch()) {
            ((StreamReceiver)this.getReceiver()).endEntity();
        }
        this.entityPathTracker.endEntity();
    }

    public void literal(String name, String value) {
        if (this.inMatch()) {
            this.startRecordIfNeeded();
            ((StreamReceiver)this.getReceiver()).literal(name, value);
        }
    }

    protected void onResetStream() {
        this.entityPathTracker.resetStream();
        this.resetRecord();
    }

    protected void onCloseStream() {
        this.entityPathTracker.closeStream();
    }

    private void resetRecord() {
        this.recordStarted = false;
        this.inMatch = false;
    }

    private void startRecordIfNeeded() {
        if (!this.recordStarted) {
            ((StreamReceiver)this.getReceiver()).startRecord(String.format(this.recordIdFormat, this.recordIdentifier, ++this.recordCount));
            this.recordStarted = true;
        }
    }

    private void endRecordIfNeeded() {
        if (this.recordStarted) {
            ((StreamReceiver)this.getReceiver()).endRecord();
            this.resetRecord();
        }
    }

    private boolean pathMatching() {
        return this.path.equals(this.entityPathTracker.getCurrentPath());
    }

    private boolean inMatch() {
        return this.inMatch || this.path.equals(ROOT_PATH);
    }
}

