/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.mangling;

import java.util.ArrayDeque;
import java.util.Deque;
import org.metafacture.framework.helpers.DefaultStreamReceiver;

public class EntityPathTracker
extends DefaultStreamReceiver {
    public static final String DEFAULT_ENTITY_SEPARATOR = ".";
    private final Deque<String> entityStack = new ArrayDeque<String>();
    private final StringBuilder currentPath = new StringBuilder();
    private String entitySeparator = ".";

    public String getCurrentPath() {
        return this.currentPath.toString();
    }

    public String getCurrentPathWith(String literalName) {
        if (this.entityStack.size() == 0) {
            return literalName;
        }
        return this.getCurrentPath() + this.entitySeparator + literalName;
    }

    public String getCurrentEntityName() {
        return this.entityStack.peek();
    }

    public String getEntitySeparator() {
        return this.entitySeparator;
    }

    public void setEntitySeparator(String entitySeparator) {
        this.entitySeparator = entitySeparator;
    }

    public void startRecord(String identifier) {
        this.clearStackAndPath();
    }

    public void endRecord() {
        this.clearStackAndPath();
    }

    public void startEntity(String name) {
        this.entityStack.push(name);
        this.appendEntityToPath();
    }

    public void endEntity() {
        this.removeEntityFromPath();
        this.entityStack.pop();
    }

    public void closeStream() {
        this.clearStackAndPath();
    }

    public void resetStream() {
        this.clearStackAndPath();
    }

    private void clearStackAndPath() {
        this.entityStack.clear();
        this.currentPath.setLength(0);
    }

    private void appendEntityToPath() {
        if (this.entityStack.size() > 1) {
            this.currentPath.append(this.entitySeparator);
        }
        this.currentPath.append(this.entityStack.peek());
    }

    private void removeEntityFromPath() {
        String entityName = this.entityStack.peek();
        int oldPathLength = this.currentPath.length();
        int lastEntityLength = entityName.length();
        if (this.entityStack.size() > 1) {
            lastEntityLength += this.entitySeparator.length();
        }
        this.currentPath.setLength(oldPathLength - lastEntityLength);
    }
}

