/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.mangling;

import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;
import org.metafacture.mangling.EntityPathTracker;

@Description(value="flattens out entities in a stream by introducing dots in literal names")
@In(value=StreamReceiver.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="flatten")
public final class StreamFlattener
extends DefaultStreamPipe<StreamReceiver> {
    public static final String DEFAULT_ENTITY_MARKER = ".";
    private final EntityPathTracker pathTracker = new EntityPathTracker();

    public StreamFlattener() {
        this.setEntityMarker(DEFAULT_ENTITY_MARKER);
    }

    public String getEntityMarker() {
        return this.pathTracker.getEntitySeparator();
    }

    public void setEntityMarker(String entityMarker) {
        this.pathTracker.setEntitySeparator(entityMarker);
    }

    public void startRecord(String identifier) {
        assert (!this.isClosed());
        this.pathTracker.startRecord(identifier);
        ((StreamReceiver)this.getReceiver()).startRecord(identifier);
    }

    public void endRecord() {
        assert (!this.isClosed());
        this.pathTracker.endRecord();
        ((StreamReceiver)this.getReceiver()).endRecord();
    }

    public void startEntity(String name) {
        assert (!this.isClosed());
        this.pathTracker.startEntity(name);
    }

    public void endEntity() {
        assert (!this.isClosed());
        this.pathTracker.endEntity();
    }

    public void literal(String name, String value) {
        assert (!this.isClosed());
        ((StreamReceiver)this.getReceiver()).literal(this.pathTracker.getCurrentPathWith(name), value);
    }

    public String getCurrentEntityName() {
        return this.pathTracker.getCurrentEntityName();
    }

    public String getCurrentPath() {
        return this.pathTracker.getCurrentPath();
    }
}

