/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.monitoring;

import org.metafacture.commons.TimeUtil;
import org.metafacture.framework.Receiver;
import org.metafacture.framework.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerBase<R extends Receiver>
implements Sender<R> {
    private static final Logger LOG = LoggerFactory.getLogger(TimerBase.class);
    private final String logPrefix;
    private long count;
    private long cumulativeDuration;
    private long startTime;
    private R receiver;

    protected TimerBase(String logPrefix) {
        this.logPrefix = logPrefix;
    }

    public final <S extends R> S setReceiver(S newReceiver) {
        this.receiver = newReceiver;
        return newReceiver;
    }

    public final R getReceiver() {
        return this.receiver;
    }

    public final void resetStream() {
        this.count = 0L;
        this.cumulativeDuration = 0L;
        if (this.receiver != null) {
            this.receiver.resetStream();
        }
    }

    public final void closeStream() {
        long averageDuration = this.count > 0L ? this.cumulativeDuration / this.count : 0L;
        LOG.info(this.logPrefix + String.format("Executions: %d; Cumulative duration: %s; Average duration: %s", this.count, TimeUtil.formatDuration((long)this.cumulativeDuration), TimeUtil.formatDuration((long)averageDuration)));
        this.startMeasurement();
        if (this.receiver != null) {
            this.receiver.closeStream();
        }
        this.stopMeasurement("Time to close stream: ");
    }

    protected final void startMeasurement() {
        this.startTime = System.nanoTime();
    }

    protected final void stopMeasurement() {
        this.stopMeasurement("Execution %1$d:");
    }

    protected final void stopMeasurement(String prefix) {
        long duration = System.nanoTime() - this.startTime;
        ++this.count;
        this.cumulativeDuration += duration;
        LOG.info(this.logPrefix + String.format(prefix + " %2$s", this.count, TimeUtil.formatDuration((long)duration)));
    }
}

