/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.plumbing;

import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;

@Description(value="Merges a sequence of batchSize records")
@In(value=StreamReceiver.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="merge-batch-stream")
public final class StreamBatchMerger
extends DefaultStreamPipe<StreamReceiver> {
    public static final long DEFAULT_BATCH_SIZE = 1L;
    private long batchSize = 1L;
    private long recordCount;

    public void setBatchSize(long batchSize) {
        this.batchSize = batchSize;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public void startRecord(String identifier) {
        if (this.recordCount == 0L) {
            ((StreamReceiver)this.getReceiver()).startRecord(identifier);
        }
        ++this.recordCount;
    }

    public void endRecord() {
        if (this.recordCount >= this.batchSize) {
            ((StreamReceiver)this.getReceiver()).endRecord();
            this.recordCount = 0L;
        }
    }

    public void startEntity(String name) {
        ((StreamReceiver)this.getReceiver()).startEntity(name);
    }

    public void endEntity() {
        ((StreamReceiver)this.getReceiver()).endEntity();
    }

    public void literal(String name, String value) {
        ((StreamReceiver)this.getReceiver()).literal(name, value);
    }

    protected void onResetStream() {
        this.recordCount = 0L;
    }

    protected void onCloseStream() {
        if (this.recordCount > 0L) {
            ((StreamReceiver)this.getReceiver()).endRecord();
            this.recordCount = 0L;
        }
    }
}

