/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.plumbing;

import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;

@In(value=StreamReceiver.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="merge-same-ids")
public final class StreamMerger
extends DefaultStreamPipe<StreamReceiver> {
    private boolean hasRecordsReceived;
    private String currentId = "";

    public void startRecord(String identifier) {
        assert (!this.isClosed());
        if (!this.currentId.equals(identifier)) {
            if (this.hasRecordsReceived) {
                ((StreamReceiver)this.getReceiver()).endRecord();
            }
            ((StreamReceiver)this.getReceiver()).startRecord(identifier);
            this.currentId = identifier;
        }
        this.hasRecordsReceived = true;
    }

    public void startEntity(String name) {
        assert (!this.isClosed());
        ((StreamReceiver)this.getReceiver()).startEntity(name);
    }

    public void endEntity() {
        assert (!this.isClosed());
        ((StreamReceiver)this.getReceiver()).endEntity();
    }

    public void literal(String name, String value) {
        assert (!this.isClosed());
        ((StreamReceiver)this.getReceiver()).literal(name, value);
    }

    protected void onResetStream() {
        this.hasRecordsReceived = false;
        this.currentId = "";
    }

    protected void onCloseStream() {
        if (this.hasRecordsReceived) {
            ((StreamReceiver)this.getReceiver()).endRecord();
        }
        this.onResetStream();
    }
}

