/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.plumbing;

import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamPipe;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultTee;

@Description(value="Replicates an event stream to an arbitrary number of stream receivers.")
@In(value=StreamReceiver.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="stream-tee")
public final class StreamTee
extends DefaultTee<StreamReceiver>
implements StreamPipe<StreamReceiver> {
    public void startRecord(String identifier) {
        for (StreamReceiver receiver : this.getReceivers()) {
            receiver.startRecord(identifier);
        }
    }

    public void endRecord() {
        for (StreamReceiver receiver : this.getReceivers()) {
            receiver.endRecord();
        }
    }

    public void startEntity(String name) {
        for (StreamReceiver receiver : this.getReceivers()) {
            receiver.startEntity(name);
        }
    }

    public void endEntity() {
        for (StreamReceiver receiver : this.getReceivers()) {
            receiver.endEntity();
        }
    }

    public void literal(String name, String value) {
        for (StreamReceiver receiver : this.getReceivers()) {
            receiver.literal(name, value);
        }
    }
}

