/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.runner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.RecognitionException;
import org.metafacture.commons.ResourceUtil;
import org.metafacture.flux.FluxCompiler;
import org.metafacture.flux.parser.FluxProgramm;
import org.metafacture.runner.util.DirectoryClassLoader;

public final class Flux {
    public static final String PLUGINS_DIR_PROPERTY = "flux.pluginsdir";
    public static final String PROVIDED_DIR_PROPERTY = "flux.provideddir";
    private static final Pattern VAR_PATTERN = Pattern.compile("([^=]*)=(.*)");
    private static final String SCRIPT_HOME = "FLUX_DIR";

    private Flux() {
    }

    public static void main(String[] args) throws IOException, RecognitionException {
        Flux.loadCustomJars();
        if (args.length < 1) {
            FluxProgramm.printHelp((PrintStream)System.out);
            System.exit(2);
        } else {
            File fluxFile = new File(args[0]);
            if (!fluxFile.exists()) {
                System.err.println("File not found: " + args[0]);
                System.exit(1);
                return;
            }
            HashMap<String, String> vars = new HashMap<String, String>();
            vars.put(SCRIPT_HOME, fluxFile.getAbsoluteFile().getParent() + System.getProperty("file.separator"));
            for (int i = 1; i < args.length; ++i) {
                Matcher matcher = VAR_PATTERN.matcher(args[i]);
                if (!matcher.find()) {
                    FluxProgramm.printHelp((PrintStream)System.err);
                    return;
                }
                vars.put(matcher.group(1), matcher.group(2));
            }
            FluxCompiler.compile((InputStream)ResourceUtil.getStream((File)fluxFile), vars).start();
        }
    }

    private static void loadCustomJars() {
        String providedDir;
        DirectoryClassLoader dirClassLoader = new DirectoryClassLoader(Flux.getClassLoader());
        String pluginsDir = System.getProperty(PLUGINS_DIR_PROPERTY);
        if (pluginsDir != null) {
            dirClassLoader.addDirectory(new File(pluginsDir));
        }
        if ((providedDir = System.getProperty(PROVIDED_DIR_PROPERTY)) != null) {
            dirClassLoader.addDirectory(new File(providedDir));
        }
        Flux.setClassLoader(dirClassLoader);
    }

    private static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static void setClassLoader(ClassLoader classLoader) {
        Thread.currentThread().setContextClassLoader(classLoader);
    }
}

