/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.statistics;

import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Pattern;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.helpers.DefaultObjectPipe;
import org.metafacture.framework.objects.Triple;

public abstract class AbstractCountProcessor
extends DefaultObjectPipe<Triple, ObjectReceiver<Triple>> {
    private static final Pattern KEY_SPLIT_PATTERN = Pattern.compile("&", 16);
    private static final String MARGINAL_PREFIX = "1:";
    private static final String JOINT_PREFIX = "2:";
    private final Map<String, Integer> marginals = new Hashtable<String, Integer>();
    private boolean inHeader = true;
    private int minCount;

    protected final int getTotal() {
        return this.getMarginal("");
    }

    protected final void setMinCount(int min) {
        this.minCount = min;
    }

    public final void process(Triple triple) {
        if (triple.getSubject().indexOf(38) == -1) {
            if (!this.inHeader) {
                throw new IllegalArgumentException("Marginal counts and joint count must not be mixed. Marginal counts must appear first, joint counts second");
            }
            if (!triple.getSubject().startsWith(MARGINAL_PREFIX)) {
                throw new IllegalArgumentException("Marginal counts must start with '1:'");
            }
            int marginal = Integer.parseInt(triple.getObject());
            if (marginal >= this.minCount) {
                this.marginals.put(triple.getSubject().substring(2), marginal);
            }
        } else {
            this.inHeader = false;
            if (!triple.getSubject().startsWith(JOINT_PREFIX)) {
                throw new IllegalArgumentException("Joint counts must start with '2:'");
            }
            int nab = Integer.parseInt(triple.getObject());
            String[] keyParts = KEY_SPLIT_PATTERN.split(triple.getSubject().substring(2));
            if (nab >= this.minCount) {
                int na = this.getMarginal(keyParts[0]);
                int nb = this.getMarginal(keyParts[1]);
                this.processCount(keyParts[0], keyParts[1], na, nb, nab);
            }
        }
    }

    protected abstract void processCount(String var1, String var2, int var3, int var4, int var5);

    private int getMarginal(String string) {
        Integer value = this.marginals.get(string);
        if (null == value) {
            return 0;
        }
        return value;
    }

    protected final void onResetStream() {
        this.marginals.clear();
        this.inHeader = true;
        this.reset();
    }

    protected void reset() {
    }

    protected final void onCloseStream() {
        this.onResetStream();
        this.close();
    }

    protected void close() {
    }
}

