/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.statistics;

import java.util.ArrayList;
import java.util.List;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.objects.Triple;
import org.metafacture.statistics.AbstractCountProcessor;

@Description(value="Calculates values for various cooccurrence metrics. The expected inputs are triples containing as subject the var name and as object the count. Marginal counts must appear first, joint counts second. Marinal counts must be written as 1:A, Joint counts as 2:A&B")
@In(value=Triple.class)
@Out(value=Triple.class)
@FluxCommand(value="calculate-metrics")
public final class CooccurrenceMetricCalculator
extends AbstractCountProcessor {
    private static final int MIN_COUNT = 5;
    private final List<Metric> metrics = new ArrayList<Metric>();

    public CooccurrenceMetricCalculator(String allMetrics) {
        this.setMinCount(5);
        for (String metric : allMetrics.split("\\s*,\\s*")) {
            this.metrics.add(Metric.valueOf(metric));
        }
    }

    public CooccurrenceMetricCalculator(Metric ... metrics) {
        this.setMinCount(5);
        for (Metric metric : metrics) {
            this.metrics.add(metric);
        }
    }

    @Override
    protected void processCount(String varA, String varB, int countA, int countB, int countAandB) {
        for (Metric metric : this.metrics) {
            double value = metric.calculate(countA, countB, countAandB, this.getTotal());
            ((ObjectReceiver)this.getReceiver()).process((Object)new Triple(varA + "&" + varB, metric.toString(), String.valueOf(value)));
        }
    }

    static enum Metric {
        X2{

            @Override
            double calculate(int countA, int countB, int countAandB, int total) {
                double o12 = countA - countAandB;
                double o21 = countB - countAandB;
                double o22 = total - countAandB;
                double d = (double)countAandB * o22 - o12 * o21;
                double x2 = (double)total * Math.pow(d, 2.0) / (((double)countAandB + o12) * ((double)countAandB + o21) * (o12 + o22) * (o21 + o22));
                return x2 * Math.signum(d);
            }
        }
        ,
        F{

            @Override
            double calculate(int countA, int countB, int countAandB, int total) {
                double pa = (double)countA / (double)total;
                double pb = (double)countB / (double)total;
                double pab = (double)countAandB / (double)total;
                double precission = pab / pa;
                double recall = pab / pb;
                return 2.0 * precission * recall / (precission + recall);
            }
        }
        ,
        PRECISSION{

            @Override
            double calculate(int countA, int countB, int countAandB, int total) {
                double pa = (double)countA / (double)total;
                double pab = (double)countAandB / (double)total;
                return pab / pa;
            }
        }
        ,
        RECALL{

            @Override
            double calculate(int countA, int countB, int countAandB, int total) {
                double pb = (double)countB / (double)total;
                double pab = (double)countAandB / (double)total;
                return pab / pb;
            }
        }
        ,
        JACCARD{

            @Override
            double calculate(int countA, int countB, int countAandB, int total) {
                return (double)countAandB / (double)(countA + countB - countAandB);
            }
        };


        abstract double calculate(int var1, int var2, int var3, int var4);
    }
}

