/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.statistics;

import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;

@Description(value="Counts the number of records and fields read.")
@In(value=StreamReceiver.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="stream-count")
public final class Counter
extends DefaultStreamPipe<StreamReceiver> {
    private int numRecords;
    private int numEntities;
    private int numLiterals;

    public int getNumRecords() {
        return this.numRecords;
    }

    public int getNumEntities() {
        return this.numEntities;
    }

    public int getNumLiterals() {
        return this.numLiterals;
    }

    public void startRecord(String identifier) {
        assert (!this.isClosed());
        ++this.numRecords;
        if (this.getReceiver() != null) {
            ((StreamReceiver)this.getReceiver()).startRecord(identifier);
        }
    }

    public void startEntity(String name) {
        assert (!this.isClosed());
        ++this.numEntities;
        if (this.getReceiver() != null) {
            ((StreamReceiver)this.getReceiver()).startEntity(name);
        }
    }

    public void literal(String name, String value) {
        assert (!this.isClosed());
        ++this.numLiterals;
        if (this.getReceiver() != null) {
            ((StreamReceiver)this.getReceiver()).literal(name, value);
        }
    }

    public void endRecord() {
        if (this.getReceiver() != null) {
            ((StreamReceiver)this.getReceiver()).endRecord();
        }
    }

    public void endEntity() {
        if (this.getReceiver() != null) {
            ((StreamReceiver)this.getReceiver()).endEntity();
        }
    }

    protected void onResetStream() {
        this.numRecords = 0;
        this.numEntities = 0;
        this.numLiterals = 0;
    }

    public String toString() {
        String streamClosed = this.isClosed() ? " Stream has been closed." : "";
        return "counted " + this.numRecords + " records, " + this.numEntities + " entities, " + this.numLiterals + " literals." + streamClosed;
    }
}

