/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.statistics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.metafacture.framework.helpers.DefaultStreamReceiver;

public final class Histogram
extends DefaultStreamReceiver {
    private final Map<String, Integer> histogram = new HashMap<String, Integer>();
    private boolean countEntities;
    private boolean countLiterals;
    private String countField;

    public Histogram() {
    }

    public Histogram(String countField) {
        this.setCountField(countField);
    }

    public Map<String, Integer> getHistogram() {
        return Collections.unmodifiableMap(this.histogram);
    }

    public boolean isCountEntities() {
        return this.countEntities;
    }

    public void setCountEntities(boolean countEntities) {
        this.countEntities = countEntities;
    }

    public boolean isCountLiterals() {
        return this.countLiterals;
    }

    public void setCountLiterals(boolean countLiterals) {
        this.countLiterals = countLiterals;
    }

    public String getCountField() {
        return this.countField;
    }

    public void setCountField(String countField) {
        this.countField = countField;
    }

    public void startEntity(String name) {
        if (this.countEntities) {
            this.count(name);
        }
    }

    public void literal(String name, String value) {
        if (this.countLiterals) {
            this.count(name);
        }
        if (name.equals(this.countField)) {
            this.count(value);
        }
    }

    public void resetStream() {
        this.histogram.clear();
    }

    private void count(String value) {
        Integer c = this.histogram.get(value);
        if (c == null) {
            c = 0;
        }
        this.histogram.put(value, c + 1);
    }
}

