/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.statistics;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;

@Description(value="Draws a uniform sample of records from the input stream.")
@In(value=Object.class)
@Out(value=Object.class)
@FluxCommand(value="draw-uniform-sample")
public final class UniformSampler<T>
extends DefaultObjectPipe<T, ObjectReceiver<T>> {
    private final int sampleSize;
    private final List<T> sample;
    private final Random random = new Random();
    private long count;

    public UniformSampler(int sampleSize) {
        this.sampleSize = sampleSize;
        this.sample = new ArrayList<T>(sampleSize);
    }

    public UniformSampler(String sampleSize) {
        this(Integer.parseInt(sampleSize));
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public void setSeed(long seed) {
        this.random.setSeed(seed);
    }

    public void process(T obj) {
        assert (!this.isClosed());
        assert (null != obj);
        ++this.count;
        if (this.sample.size() < this.sampleSize) {
            this.sample.add(obj);
        } else {
            double p = (double)this.sampleSize / (double)this.count;
            if (this.random.nextDouble() < p) {
                this.sample.set(this.random.nextInt(this.sampleSize), obj);
            }
        }
    }

    protected void onCloseStream() {
        for (T obj : this.sample) {
            ((ObjectReceiver)this.getReceiver()).process(obj);
        }
        this.sample.clear();
        this.count = 0L;
    }

    protected void onResetStream() {
        this.sample.clear();
        this.count = 0L;
    }
}

