/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.xml;

import java.util.regex.Pattern;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.XmlReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultXmlPipe;
import org.xml.sax.Attributes;

@Description(value="A generic xml reader")
@In(value=XmlReceiver.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="handle-generic-xml")
public final class GenericXmlHandler
extends DefaultXmlPipe<StreamReceiver> {
    public static final String RECORD_TAG_PROPERTY = "org.culturegraph.metamorph.xml.recordtag";
    public static final boolean EMIT_NAMESPACE = false;
    private static final Pattern TABS = Pattern.compile("\t+");
    private String attributeMarker = "";
    private String recordTagName = "record";
    private String valueTagName = "value";
    private boolean inRecord;
    private StringBuilder valueBuffer = new StringBuilder();
    private boolean emitNamespace = false;

    public GenericXmlHandler() {
        String recordTagNameProperty = System.getProperty(RECORD_TAG_PROPERTY);
        if (recordTagNameProperty != null) {
            this.recordTagName = recordTagNameProperty;
        }
    }

    @Deprecated
    public GenericXmlHandler(String recordTagName) {
        this.recordTagName = recordTagName;
    }

    public void setRecordTagName(String recordTagName) {
        this.recordTagName = recordTagName;
    }

    public String getRecordTagName() {
        return this.recordTagName;
    }

    public void setValueTagName(String valueTagName) {
        this.valueTagName = valueTagName;
    }

    public String getValueTagName() {
        return this.valueTagName;
    }

    public void setEmitNamespace(boolean emitNamespace) {
        this.emitNamespace = emitNamespace;
    }

    public boolean getEmitNamespace() {
        return this.emitNamespace;
    }

    public void setAttributeMarker(String attributeMarker) {
        this.attributeMarker = attributeMarker;
    }

    public String getAttributeMarker() {
        return this.attributeMarker;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.inRecord) {
            this.writeValue();
            if (this.emitNamespace) {
                ((StreamReceiver)this.getReceiver()).startEntity(qName);
            } else {
                ((StreamReceiver)this.getReceiver()).startEntity(localName);
            }
            this.writeAttributes(attributes);
        } else if (localName.equals(this.recordTagName)) {
            String identifier = attributes.getValue("id");
            if (identifier == null) {
                ((StreamReceiver)this.getReceiver()).startRecord("");
            } else {
                ((StreamReceiver)this.getReceiver()).startRecord(identifier);
            }
            this.writeAttributes(attributes);
            this.inRecord = true;
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (this.inRecord) {
            this.writeValue();
            if (localName.equals(this.recordTagName)) {
                this.inRecord = false;
                ((StreamReceiver)this.getReceiver()).endRecord();
            } else {
                ((StreamReceiver)this.getReceiver()).endEntity();
            }
        }
    }

    public void characters(char[] chars, int start, int length) {
        if (this.inRecord) {
            this.valueBuffer.append(TABS.matcher(new String(chars, start, length)).replaceAll(""));
        }
    }

    private void writeValue() {
        String value = this.valueBuffer.toString();
        if (!value.trim().isEmpty()) {
            ((StreamReceiver)this.getReceiver()).literal(this.valueTagName, value.replace('\n', ' '));
        }
        this.valueBuffer = new StringBuilder();
    }

    private void writeAttributes(Attributes attributes) {
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            String name = this.emitNamespace ? attributes.getQName(i) : attributes.getLocalName(i);
            String value = attributes.getValue(i);
            ((StreamReceiver)this.getReceiver()).literal(this.attributeMarker + name, value);
        }
    }
}

