/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.file.Paths;
import java.util.function.Function;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;
import org.metafacture.xml.FilenameExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

@Description(value="Writes the xml into the filesystem. The filename is constructed from the xpath given as 'property'.\n Variables are\n- 'target' (determining the output directory)\n- 'property' (the element in the XML entity. Constitutes the main part of the file's name.)\n- 'startIndex' ( a subfolder will be extracted out of the filename. This marks the index' beginning )\n- 'stopIndex' ( a subfolder will be extracted out of the filename. This marks the index' end )\n")
@In(value=StreamReceiver.class)
@Out(value=Void.class)
@FluxCommand(value="write-xml-files")
public final class XmlFilenameWriter
extends DefaultStreamPipe<ObjectReceiver<String>>
implements FilenameExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(XmlFilenameWriter.class);
    private final XPath xPath = XPathFactory.newInstance().newXPath();
    private final FilenameExtractor.FilenameUtil filenameUtil = new FilenameExtractor.FilenameUtil();
    private String compression;

    public XmlFilenameWriter() {
        this.setFileSuffix(".xml");
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    @Override
    public void setEncoding(String encoding) {
        this.filenameUtil.setEncoding(encoding);
    }

    @Override
    public String getEncoding() {
        return this.filenameUtil.getEncoding();
    }

    @Override
    public void setEndIndex(int endIndex) {
        this.filenameUtil.setEndIndex(endIndex);
    }

    @Override
    public void setFileSuffix(String fileSuffix) {
        this.filenameUtil.setFileSuffix(fileSuffix);
    }

    @Override
    public void setProperty(String property) {
        this.filenameUtil.setProperty(property);
    }

    @Override
    public void setStartIndex(int startIndex) {
        this.filenameUtil.setStartIndex(startIndex);
    }

    @Override
    public void setTarget(String target) {
        this.filenameUtil.setTarget(target);
    }

    public void literal(String str, String xml) {
        String identifier = this.extractIdentifier(xml);
        if (identifier == null) {
            return;
        }
        File file = this.buildTargetFileName(identifier);
        this.filenameUtil.ensurePathExists(file);
        if (this.compression == null) {
            this.writeXml(xml, file);
        } else if ("bz2".equals(this.compression)) {
            File compressedFile = new File(file.getPath() + ".bz2");
            this.writeXml(xml, compressedFile, this::createBZip2Compressor);
        }
    }

    private String extractIdentifier(String xml) {
        String identifier;
        try {
            identifier = this.xPath.evaluate(this.filenameUtil.getProperty(), new InputSource(new StringReader(xml)));
        }
        catch (XPathExpressionException e) {
            throw new MetafactureException((Throwable)e);
        }
        if (identifier == null || identifier.length() < this.filenameUtil.getEndIndex()) {
            LOG.info("No identifier found, skip writing");
            LOG.debug("the xml: {}", (Object)xml);
            return null;
        }
        return identifier;
    }

    private File buildTargetFileName(String identifier) {
        String directory = identifier.substring(this.filenameUtil.getStartIndex(), this.filenameUtil.getEndIndex());
        return Paths.get(this.filenameUtil.getTarget(), new String[0]).resolve(directory).resolve(identifier + this.filenameUtil.getFileSuffix()).toFile();
    }

    private void writeXml(String xml, File file) {
        this.writeXml(xml, file, Function.identity());
    }

    private void writeXml(String xml, File file, Function<OutputStream, OutputStream> compressorFactory) {
        try (FileOutputStream fileStream = new FileOutputStream(file);
             OutputStream compressedStream = compressorFactory.apply(fileStream);
             OutputStreamWriter writer = new OutputStreamWriter(compressedStream, this.filenameUtil.getEncoding());){
            writer.write(xml);
        }
        catch (IOException | UncheckedIOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    private OutputStream createBZip2Compressor(OutputStream stream) {
        try {
            return new BZip2CompressorOutputStream(stream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

