/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.xml;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.metafacture.commons.ResourceUtil;
import org.metafacture.commons.XmlUtil;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;

@Description(value="Encodes a stream as xml")
@In(value=StreamReceiver.class)
@Out(value=String.class)
@FluxCommand(value="stream-to-xml")
public final class SimpleXmlEncoder
extends DefaultStreamPipe<ObjectReceiver<String>> {
    public static final String ATTRIBUTE_MARKER = "~";
    public static final String DEFAULT_VALUE_TAG = "";
    private static final String NEW_LINE = "\n";
    private static final String INDENT = "\t";
    private static final String BEGIN_ATTRIBUTE = "=\"";
    private static final String END_ATTRIBUTE = "\"";
    private static final String BEGIN_OPEN_ELEMENT = "<";
    private static final String END_OPEN_ELEMENT = ">";
    private static final String END_EMPTY_ELEMENT = " />";
    private static final String BEGIN_CLOSE_ELEMENT = "</";
    private static final String END_CLOSE_ELEMENT = ">";
    private static final String XML_HEADER = "<?xml version=\"%s\" encoding=\"%s\"?>\n";
    private static final String XMLNS_MARKER = " xmlns";
    private static final String DEFAULT = "__default";
    private final StringBuilder builder = new StringBuilder();
    private String attributeMarker = "~";
    private String rootTag = "records";
    private String recordTag = "record";
    private String valueTag = "";
    private Map<String, String> namespaces = new HashMap<String, String>();
    private boolean writeRootTag = true;
    private boolean writeXmlHeader = true;
    private String xmlHeaderEncoding = "UTF-8";
    private String xmlHeaderVersion = "1.0";
    private boolean separateRoots;
    private Element element;
    private boolean atStreamStart = true;

    public void setRootTag(String rootTag) {
        this.rootTag = rootTag;
    }

    public void setRecordTag(String tag) {
        this.recordTag = tag;
    }

    public void setValueTag(String valueTag) {
        this.valueTag = valueTag;
    }

    public String getValueTag() {
        return this.valueTag;
    }

    public void setNamespaceFile(String file) {
        Properties properties;
        try {
            properties = ResourceUtil.loadProperties((String)file);
        }
        catch (IOException e) {
            throw new MetafactureException("Failed to load namespaces list", (Throwable)e);
        }
        this.propertiesToMap(properties);
    }

    public void setNamespaceFile(URL url) {
        Properties properties;
        try {
            properties = ResourceUtil.loadProperties((URL)url);
        }
        catch (IOException e) {
            throw new MetafactureException("Failed to load namespaces list", (Throwable)e);
        }
        this.propertiesToMap(properties);
    }

    public void setWriteXmlHeader(boolean writeXmlHeader) {
        this.writeXmlHeader = writeXmlHeader;
    }

    public void setXmlHeaderEncoding(String xmlHeaderEncoding) {
        this.xmlHeaderEncoding = xmlHeaderEncoding;
    }

    public void setXmlHeaderVersion(String xmlHeaderVersion) {
        this.xmlHeaderVersion = xmlHeaderVersion;
    }

    public void setWriteRootTag(boolean writeRootTag) {
        this.writeRootTag = writeRootTag;
    }

    public void setSeparateRoots(boolean separateRoots) {
        this.separateRoots = separateRoots;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    public void setNamespaces(String namespacesString) {
        Properties properties = new Properties();
        try (StringReader sr = new StringReader(namespacesString);){
            properties.load(sr);
        }
        catch (IOException e) {
            throw new MetafactureException("Failed to create namespace list");
        }
        this.propertiesToMap(properties);
    }

    public void setAttributeMarker(String attributeMarker) {
        this.attributeMarker = attributeMarker;
    }

    public String getAttributeMarker() {
        return this.attributeMarker;
    }

    public void startRecord(String identifier) {
        if (this.separateRoots) {
            this.writeHeader();
        } else if (this.atStreamStart) {
            this.writeHeader();
            this.sendAndClearData();
        }
        this.atStreamStart = false;
        this.element = new Element(this.recordTag);
        if (!this.writeRootTag) {
            this.addNamespacesToElement();
        }
    }

    private void addNamespacesToElement() {
        for (Map.Entry<String, String> namespace : this.namespaces.entrySet()) {
            String key = namespace.getKey();
            String name = XMLNS_MARKER + (String)(this.isDefaultNamespace(key) ? DEFAULT_VALUE_TAG : ":" + key);
            this.element.addAttribute(name, namespace.getValue());
        }
    }

    public void endRecord() {
        this.element.writeElement(this.builder, 1);
        if (this.separateRoots) {
            this.writeFooter();
        }
        this.sendAndClearData();
    }

    public void startEntity(String name) {
        this.element = this.element.createChild(name);
    }

    public void endEntity() {
        this.element = this.element.getParent();
    }

    public void literal(String name, String value) {
        if (name.equals(this.valueTag)) {
            this.element.setText(value);
        } else if (name.startsWith(this.attributeMarker)) {
            this.element.addAttribute(name.substring(this.attributeMarker.length()), value);
        } else {
            this.element.createChild(name).setText(value);
        }
    }

    protected void onResetStream() {
        if (!this.atStreamStart) {
            this.writeFooter();
        }
        this.sendAndClearData();
        this.atStreamStart = true;
    }

    protected void onCloseStream() {
        if (!this.separateRoots) {
            if (!this.atStreamStart) {
                this.writeFooter();
            }
            this.sendAndClearData();
        }
    }

    private void sendAndClearData() {
        ((ObjectReceiver)this.getReceiver()).process((Object)this.builder.toString());
        this.builder.delete(0, this.builder.length());
    }

    private void writeHeader() {
        if (this.writeXmlHeader) {
            this.builder.append(String.format(XML_HEADER, this.xmlHeaderVersion, this.xmlHeaderEncoding));
        }
        if (this.writeRootTag) {
            this.builder.append(BEGIN_OPEN_ELEMENT);
            this.builder.append(this.rootTag);
            for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
                this.builder.append(XMLNS_MARKER);
                if (!this.isDefaultNamespace(entry.getKey())) {
                    this.builder.append(':');
                    this.builder.append(entry.getKey());
                }
                this.builder.append(BEGIN_ATTRIBUTE);
                SimpleXmlEncoder.writeEscaped(this.builder, entry.getValue());
                this.builder.append(END_ATTRIBUTE);
            }
            this.builder.append(">");
        }
    }

    private void writeFooter() {
        if (this.writeRootTag) {
            this.builder.append(NEW_LINE);
            this.builder.append(BEGIN_CLOSE_ELEMENT);
            this.builder.append(this.rootTag);
            this.builder.append(">");
        }
    }

    protected static void writeEscaped(StringBuilder builder, String str) {
        builder.append(XmlUtil.escape((String)str, (boolean)false));
    }

    private boolean isDefaultNamespace(String ns) {
        return ns.isEmpty() || ns.equals(DEFAULT);
    }

    private void propertiesToMap(Properties properties) {
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.namespaces.put(k.toString(), v.toString())));
    }

    private static final class Element {
        private static final List<Element> NO_CHILDREN = Collections.emptyList();
        private final StringBuilder attributes = new StringBuilder();
        private final Element parent;
        private final String name;
        private String text = "";
        private List<Element> children = NO_CHILDREN;

        Element(String name) {
            this.name = name;
            this.parent = null;
        }

        private Element(String name, Element parent) {
            this.name = name;
            this.parent = parent;
        }

        public void addAttribute(String attributeName, String value) {
            this.attributes.append(" ");
            this.attributes.append(attributeName);
            this.attributes.append(SimpleXmlEncoder.BEGIN_ATTRIBUTE);
            SimpleXmlEncoder.writeEscaped(this.attributes, value);
            this.attributes.append(SimpleXmlEncoder.END_ATTRIBUTE);
        }

        public void setText(String text) {
            this.text = text;
        }

        public Element createChild(String attributeName) {
            Element child = new Element(attributeName, this);
            if (this.children == NO_CHILDREN) {
                this.children = new ArrayList<Element>();
            }
            this.children.add(child);
            return child;
        }

        public Element getParent() {
            return this.parent;
        }

        public void writeElement(StringBuilder builder, int indent) {
            if (!this.name.isEmpty()) {
                builder.append(SimpleXmlEncoder.NEW_LINE);
                Element.writeIndent(builder, indent);
                builder.append(SimpleXmlEncoder.BEGIN_OPEN_ELEMENT);
                builder.append(this.name);
                builder.append((CharSequence)this.attributes);
                if (this.text.isEmpty() && this.children.isEmpty()) {
                    builder.append(SimpleXmlEncoder.END_EMPTY_ELEMENT);
                    return;
                }
                builder.append(">");
            }
            SimpleXmlEncoder.writeEscaped(builder, this.text);
            for (Element element : this.children) {
                element.writeElement(builder, indent + 1);
            }
            if (this.text.isEmpty() && !this.children.isEmpty()) {
                builder.append(SimpleXmlEncoder.NEW_LINE);
                Element.writeIndent(builder, indent);
            }
            if (!this.name.isEmpty()) {
                builder.append(SimpleXmlEncoder.BEGIN_CLOSE_ELEMENT);
                builder.append(this.name);
                builder.append(">");
            }
        }

        private static void writeIndent(StringBuilder builder, int indent) {
            for (int i = 0; i < indent; ++i) {
                builder.append(SimpleXmlEncoder.INDENT);
            }
        }
    }
}

