/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.xml;

import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.XmlReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

@Description(value="Reads an XML file and passes the XML events to a receiver.")
@In(value=Reader.class)
@Out(value=XmlReceiver.class)
@FluxCommand(value="decode-xml")
public final class XmlDecoder
extends DefaultObjectPipe<Reader, XmlReceiver> {
    private static final String SAX_PROPERTY_LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private final XMLReader saxReader;

    public XmlDecoder() {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            this.saxReader = parserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    public void process(Reader reader) {
        try {
            this.saxReader.parse(new InputSource(reader));
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
        catch (SAXException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    protected void onSetReceiver() {
        this.saxReader.setContentHandler((ContentHandler)this.getReceiver());
        this.saxReader.setDTDHandler((DTDHandler)this.getReceiver());
        this.saxReader.setEntityResolver((EntityResolver)this.getReceiver());
        this.saxReader.setErrorHandler((ErrorHandler)this.getReceiver());
        try {
            this.saxReader.setProperty(SAX_PROPERTY_LEXICAL_HANDLER, this.getReceiver());
        }
        catch (SAXNotRecognizedException e) {
            throw new MetafactureException((Throwable)e);
        }
        catch (SAXNotSupportedException e) {
            throw new MetafactureException((Throwable)e);
        }
    }
}

