/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.api.helpers;

import org.metafacture.metamorph.api.Collect;
import org.metafacture.metamorph.api.NamedValueSource;
import org.metafacture.metamorph.api.helpers.AbstractNamedValuePipe;

public abstract class AbstractCollect
extends AbstractNamedValuePipe
implements Collect {
    private int oldRecord;
    private int oldEntity;
    private boolean resetAfterEmit;
    private boolean sameEntity;
    private String name;
    private String value;
    private boolean waitForFlush;
    private boolean conditionMet;
    private NamedValueSource conditionSource;

    protected final int getRecordCount() {
        return this.oldRecord;
    }

    protected final int getEntityCount() {
        return this.oldEntity;
    }

    protected final boolean isConditionMet() {
        return this.conditionMet;
    }

    protected final void setConditionMet(boolean conditionMet) {
        this.conditionMet = conditionMet;
    }

    protected final void resetCondition() {
        this.setConditionMet(this.conditionSource == null);
    }

    @Override
    public final void setWaitForFlush(boolean waitForFlush) {
        this.waitForFlush = waitForFlush;
    }

    @Override
    public final void setSameEntity(boolean sameEntity) {
        this.sameEntity = sameEntity;
    }

    public final boolean getReset() {
        return this.resetAfterEmit;
    }

    @Override
    public final void setReset(boolean reset) {
        this.resetAfterEmit = reset;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String name) {
        this.name = name;
    }

    @Override
    public final void setConditionSource(NamedValueSource source) {
        this.conditionSource = source;
        this.conditionSource.setNamedValueReceiver(this);
        this.resetCondition();
    }

    public final String getValue() {
        return this.value;
    }

    public final void setValue(String value) {
        this.value = value;
    }

    protected final void updateCounts(int currentRecord, int currentEntity) {
        if (!this.isSameRecord(currentRecord)) {
            this.resetCondition();
            this.clear();
            this.oldRecord = currentRecord;
        }
        if (this.resetNeedFor(currentEntity)) {
            this.resetCondition();
            this.clear();
        }
        this.oldEntity = currentEntity;
    }

    private boolean resetNeedFor(int currentEntity) {
        return this.sameEntity && this.oldEntity != currentEntity;
    }

    protected final boolean isSameRecord(int currentRecord) {
        return currentRecord == this.oldRecord;
    }

    @Override
    public final void receive(String name, String value, NamedValueSource source, int recordCount, int entityCount) {
        this.updateCounts(recordCount, entityCount);
        if (source == this.conditionSource) {
            this.conditionMet = true;
        } else {
            this.receive(name, value, source);
        }
        if (!this.waitForFlush && this.isConditionMet() && this.isComplete()) {
            this.emit();
            if (this.resetAfterEmit) {
                this.resetCondition();
                this.clear();
            }
        }
    }

    protected final boolean sameEntityConstraintSatisfied(int entityCount) {
        return !this.sameEntity || this.oldEntity == entityCount;
    }

    protected abstract void receive(String var1, String var2, NamedValueSource var3);

    protected abstract boolean isComplete();

    protected abstract void clear();

    protected abstract void emit();
}

