/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.api.helpers;

import org.metafacture.metamorph.api.NamedValueSource;
import org.metafacture.metamorph.api.helpers.AbstractFunction;

public abstract class AbstractStatefulFunction
extends AbstractFunction {
    private int recordCount;
    private int entityCount;
    private NamedValueSource source;
    private String lastName;

    protected final int getRecordCount() {
        return this.recordCount;
    }

    protected final int getEntityCount() {
        return this.entityCount;
    }

    protected final NamedValueSource getNamedValueSource() {
        return this.source;
    }

    protected final String getLastName() {
        return this.lastName;
    }

    @Override
    public final void receive(String name, String value, NamedValueSource source, int recordCount, int entityCount) {
        if (!this.sameRecord(recordCount)) {
            this.reset();
            this.recordCount = recordCount;
        }
        if (this.entityClearNeeded(entityCount)) {
            this.reset();
        }
        this.entityCount = entityCount;
        this.source = source;
        this.lastName = name;
        String processedValue = this.process(value);
        if (processedValue == null) {
            return;
        }
        this.getNamedValueReceiver().receive(name, processedValue, this, recordCount, entityCount);
    }

    private boolean entityClearNeeded(int entityCount) {
        return this.doResetOnEntityChange() && this.entityCount != entityCount;
    }

    private boolean sameRecord(int recordCount) {
        return this.recordCount == recordCount;
    }

    protected abstract String process(String var1);

    protected abstract void reset();

    protected abstract boolean doResetOnEntityChange();
}

