/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.api.helpers;

import org.metafacture.metamorph.api.NamedValueSource;
import org.metafacture.metamorph.api.helpers.AbstractFunction;

public abstract class AbstractStatefulFunction
extends AbstractFunction {
    private int recordCount;
    private int entityCount;
    private NamedValueSource source;
    private String lastName;

    protected final int getRecordCount() {
        return this.recordCount;
    }

    protected final int getEntityCount() {
        return this.entityCount;
    }

    protected final NamedValueSource getNamedValueSource() {
        return this.source;
    }

    protected final String getLastName() {
        return this.lastName;
    }

    @Override
    public final void receive(String currentName, String value, NamedValueSource currentSource, int currentRecordCount, int currentEntityCount) {
        if (!this.sameRecord(currentRecordCount)) {
            this.reset();
            this.recordCount = currentRecordCount;
        }
        if (this.entityClearNeeded(currentEntityCount)) {
            this.reset();
        }
        this.entityCount = currentEntityCount;
        this.source = currentSource;
        this.lastName = currentName;
        String processedValue = this.process(value);
        if (processedValue == null) {
            return;
        }
        this.getNamedValueReceiver().receive(currentName, processedValue, this, currentRecordCount, currentEntityCount);
    }

    private boolean entityClearNeeded(int currentEntityCount) {
        return this.doResetOnEntityChange() && this.entityCount != currentEntityCount;
    }

    private boolean sameRecord(int currentRecordCount) {
        return this.recordCount == currentRecordCount;
    }

    protected abstract String process(String var1);

    protected abstract void reset();

    protected abstract boolean doResetOnEntityChange();
}

