/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph;

import java.util.HashMap;
import java.util.Map;
import org.metafacture.commons.StringUtil;
import org.metafacture.commons.types.ScopedHashMap;
import org.metafacture.metamorph.CollectFactory;
import org.metafacture.metamorph.Entity;
import org.metafacture.metamorph.FunctionFactory;
import org.metafacture.metamorph.MapFactory;
import org.metafacture.metamorph.api.MorphBuildException;
import org.metafacture.metamorph.xml.DomLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class AbstractMetamorphDomWalker {
    protected static final String ENTITY = "entity";
    private static final String DATA = "data";
    private static final String MAP = "map";
    private static final String CALL_MACRO = "call-macro";
    private static final String IF = "if";
    private static final String POSTPROCESS = "postprocess";
    private static final String ENTITY_NAME = "entity-name";
    private static final String SCHEMA_FILE = "schemata/metamorph.xsd";
    private static final int LOWEST_COMPATIBLE_VERSION = 1;
    private static final int CURRENT_VERSION = 1;
    private FunctionFactory functionFactory;
    private CollectFactory collectFactory;
    private MapFactory mapFactory;
    private final Map<String, Node> macros = new HashMap<String, Node>();
    private ScopedHashMap<String, String> vars = new ScopedHashMap();
    private boolean ignoreMissingVars;

    protected final FunctionFactory getFunctionFactory() {
        return this.functionFactory;
    }

    protected final CollectFactory getCollectFactory() {
        return this.collectFactory;
    }

    protected final MapFactory getMapFactory() {
        return this.mapFactory;
    }

    public final void walk(InputSource morphScript, Map<String, String> newVars) {
        this.vars.putAll(newVars);
        this.walk(morphScript);
    }

    public final void walk(InputSource morphScript) {
        this.walk(DomLoader.parse(SCHEMA_FILE, morphScript));
    }

    protected final void walk(Document doc) {
        this.functionFactory = new FunctionFactory();
        this.collectFactory = new CollectFactory();
        this.collectFactory.registerClass(ENTITY, Entity.class);
        this.mapFactory = new MapFactory();
        this.init();
        Element root = doc.getDocumentElement();
        int version = Integer.parseInt(AbstractMetamorphDomWalker.attribute(root, AttributeName.VERSION));
        this.checkVersionCompatibility(version);
        this.setEntityMarker(AbstractMetamorphDomWalker.attribute(root, AttributeName.ENTITY_MARKER));
        block8: for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (AbstractMetamorphDomWalker.tagOf(node)) {
                case META: {
                    this.handleMeta(node);
                    continue block8;
                }
                case FUNCTIONS: {
                    this.handleFunctionDefinitions(node);
                    continue block8;
                }
                case RULES: {
                    this.handleRules(node);
                    continue block8;
                }
                case MAPS: {
                    this.handleMaps(node);
                    continue block8;
                }
                case VARS: {
                    this.handleVars(node);
                    continue block8;
                }
                case MACROS: {
                    this.handleMacros(node);
                    continue block8;
                }
                default: {
                    this.illegalChild(node);
                }
            }
        }
        this.finish();
    }

    private static Tags tagOf(Node child) {
        return Tags.valueOf(child.getLocalName().toUpperCase());
    }

    protected static String attribute(Node node, AttributeName attr) {
        Node attrNode = node.getAttributes().getNamedItem(attr.getString());
        if (attrNode != null) {
            return attrNode.getNodeValue();
        }
        return null;
    }

    protected static Map<String, String> attributeMap(Node elementNode) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        NamedNodeMap attrNodes = elementNode.getAttributes();
        for (int i = 0; i < attrNodes.getLength(); ++i) {
            Node attrNode = attrNodes.item(i);
            attributes.put(attrNode.getLocalName(), attrNode.getNodeValue());
        }
        return attributes;
    }

    protected final String resolveVars(String string) {
        return StringUtil.format((String)string, (String)"$[", (String)"]", (boolean)this.ignoreMissingVars, this.vars);
    }

    protected final void setIgnoreMissingVars(boolean ignoreMissingVars) {
        this.ignoreMissingVars = ignoreMissingVars;
    }

    protected final String resolvedAttribute(Node node, AttributeName attr) {
        String value = AbstractMetamorphDomWalker.attribute(node, attr);
        if (null == value) {
            return null;
        }
        return this.resolveVars(value);
    }

    protected final Map<String, String> resolvedAttributeMap(Node node) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        NamedNodeMap attrNode = node.getAttributes();
        for (int i = 0; i < attrNode.getLength(); ++i) {
            Node itemNode = attrNode.item(i);
            attributes.put(itemNode.getLocalName(), this.resolveVars(itemNode.getNodeValue()));
        }
        return attributes;
    }

    private void handleMeta(Node node) {
        for (Node metaEntryNode = node.getFirstChild(); metaEntryNode != null; metaEntryNode = metaEntryNode.getNextSibling()) {
            this.handleMetaEntry(metaEntryNode.getLocalName(), metaEntryNode.getTextContent());
        }
    }

    private void handleFunctionDefinitions(Node node) {
        for (Node functionDefNode = node.getFirstChild(); functionDefNode != null; functionDefNode = functionDefNode.getNextSibling()) {
            this.handleFunctionDefinition(functionDefNode);
        }
    }

    private void handleRules(Node node) {
        for (Node ruleNode = node.getFirstChild(); ruleNode != null; ruleNode = ruleNode.getNextSibling()) {
            this.handleRule(ruleNode);
        }
    }

    private void handleRule(Node node) {
        String nodeName = node.getLocalName();
        if (this.getCollectFactory().containsKey(nodeName)) {
            this.enterCollect(node);
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (IF.equals(child.getLocalName())) {
                    this.enterIf(child);
                    this.handleRule(child.getFirstChild());
                    this.exitIf(child);
                    continue;
                }
                if (POSTPROCESS.equals(child.getLocalName())) {
                    this.handlePostprocess(child);
                    continue;
                }
                if (ENTITY_NAME.equals(child.getLocalName())) {
                    this.enterName(child);
                    this.handleRule(child.getFirstChild());
                    this.exitName(child);
                    continue;
                }
                this.handleRule(child);
            }
            this.exitCollect(node);
        } else if (DATA.equals(nodeName)) {
            this.enterData(node);
            this.handlePostprocess(node);
            this.exitData(node);
        } else if (CALL_MACRO.equals(nodeName)) {
            String macroName = AbstractMetamorphDomWalker.attribute(node, AttributeName.NAME);
            Node macroNode = this.macros.get(macroName);
            if (macroNode == null) {
                throw new MorphBuildException("Macro '" + macroName + "' undefined!");
            }
            this.vars = new ScopedHashMap(this.vars);
            this.vars.putAll(this.resolvedAttributeMap(node));
            this.handleRules(macroNode);
            this.vars = this.vars.getOuterScope();
        } else {
            this.illegalChild(node);
        }
    }

    private void handlePostprocess(Node node) {
        for (Node functionNode = node.getFirstChild(); functionNode != null; functionNode = functionNode.getNextSibling()) {
            this.handleFunction(functionNode);
        }
    }

    private void handleMaps(Node node) {
        for (Node mapNode = node.getFirstChild(); mapNode != null; mapNode = mapNode.getNextSibling()) {
            if (MAP.equals(mapNode.getLocalName())) {
                this.handleInternalMap(mapNode);
                continue;
            }
            this.handleMapClass(mapNode);
        }
    }

    private void handleVars(Node varsNode) {
        for (Node varNode = varsNode.getFirstChild(); varNode != null; varNode = varNode.getNextSibling()) {
            String varName = AbstractMetamorphDomWalker.attribute(varNode, AttributeName.NAME);
            String varValue = AbstractMetamorphDomWalker.attribute(varNode, AttributeName.VALUE);
            this.vars.put((Object)varName, (Object)varValue);
        }
        this.vars = new ScopedHashMap(this.vars);
    }

    private void handleMacros(Node node) {
        for (Node macroNode = node.getFirstChild(); macroNode != null; macroNode = macroNode.getNextSibling()) {
            String name = AbstractMetamorphDomWalker.attribute(macroNode, AttributeName.NAME);
            this.macros.put(name, macroNode);
        }
    }

    private void checkVersionCompatibility(int version) {
        if (version < 1 || version > 1) {
            throw new MorphBuildException("Version " + version + " of definition file not supported by metamorph version " + 1);
        }
    }

    protected final void illegalChild(Node child) {
        throw new MorphBuildException("Schema mismatch: illegal tag " + child.getLocalName() + " in node " + child.getParentNode().getLocalName());
    }

    protected abstract void init();

    protected abstract void finish();

    protected abstract void setEntityMarker(String var1);

    protected abstract void handleInternalMap(Node var1);

    protected abstract void handleMapClass(Node var1);

    protected abstract void handleMetaEntry(String var1, String var2);

    protected abstract void handleFunctionDefinition(Node var1);

    protected abstract void enterData(Node var1);

    protected abstract void exitData(Node var1);

    protected abstract void enterCollect(Node var1);

    protected abstract void exitCollect(Node var1);

    protected abstract void enterName(Node var1);

    protected abstract void exitName(Node var1);

    protected abstract void enterIf(Node var1);

    protected abstract void exitIf(Node var1);

    protected abstract void handleFunction(Node var1);

    public static enum AttributeName {
        VERSION("version"),
        SOURCE("source"),
        VALUE("value"),
        NAME("name"),
        CLASS("class"),
        DEFAULT("default"),
        ENTITY_MARKER("entityMarker"),
        FLUSH_WITH("flushWith");

        private final String string;

        private AttributeName(String string2) {
            this.string = string2;
        }

        public String getString() {
            return this.string;
        }
    }

    public static enum Tags {
        META,
        FUNCTIONS,
        RULES,
        MACROS,
        MACRO,
        MAPS,
        ENTITY,
        MAP,
        ENTRY,
        TEXT,
        VARS;

    }
}

