/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph;

import java.util.Map;
import org.metafacture.flowcontrol.StreamBuffer;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;
import org.metafacture.javaintegration.SingleValue;
import org.metafacture.metamorph.Metamorph;
import org.metafacture.metamorph.api.InterceptorFactory;

@Description(value="Filters a stream based on a morph definition. A record is accepted if the morph returns at least one non empty value.")
@In(value=StreamReceiver.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="filter")
public final class Filter
extends DefaultStreamPipe<StreamReceiver> {
    private final StreamBuffer buffer = new StreamBuffer();
    private final SingleValue singleValue = new SingleValue();
    private final Metamorph metamorph;

    public Filter(String morphDef) {
        this.metamorph = new Metamorph(morphDef);
        this.metamorph.setReceiver(this.singleValue);
    }

    public Filter(Metamorph metamorph) {
        this.metamorph = metamorph;
        metamorph.setReceiver(this.singleValue);
    }

    public Filter(String morphDef, Map<String, String> vars) {
        this.metamorph = new Metamorph(morphDef, vars);
        this.metamorph.setReceiver(this.singleValue);
    }

    public Filter(String morphDef, InterceptorFactory interceptorFactory) {
        this.metamorph = new Metamorph(morphDef, interceptorFactory);
        this.metamorph.setReceiver(this.singleValue);
    }

    protected void onSetReceiver() {
        this.buffer.setReceiver(this.getReceiver());
    }

    private void dispatch() {
        String key = this.singleValue.getValue();
        if (!key.isEmpty()) {
            this.buffer.replay();
        }
        this.buffer.clear();
    }

    public void startRecord(String identifier) {
        this.buffer.startRecord(identifier);
        this.metamorph.startRecord(identifier);
    }

    public void endRecord() {
        this.buffer.endRecord();
        this.metamorph.endRecord();
        this.dispatch();
    }

    public void startEntity(String name) {
        this.buffer.startEntity(name);
        this.metamorph.startEntity(name);
    }

    public void endEntity() {
        this.buffer.endEntity();
        this.metamorph.endEntity();
    }

    public void literal(String name, String value) {
        this.buffer.literal(name, value);
        this.metamorph.literal(name, value);
    }

    protected void onResetStream() {
        this.buffer.clear();
        this.metamorph.resetStream();
    }

    protected void onCloseStream() {
        this.buffer.clear();
        this.metamorph.closeStream();
    }
}

