/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph;

import java.io.StringReader;
import java.net.URL;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.metamorph.Metamorph;
import org.xml.sax.InputSource;

public final class InlineMorph {
    private static final String XML_BOILERPLATE = "<?xml version='1.1' encoding='UTF-8'?>\n";
    private static final String METAMORPH_BOILERPLATE = "<metamorph version='1'\n    xmlns='http://www.culturegraph.org/metamorph'>";
    private static final String FINISH_METAMORPH_BOILERPLATE = "</metamorph>\n";
    private final StringBuilder scriptBuilder = new StringBuilder();
    private String systemId;
    private boolean needFinishMetamorphBoilerplate;

    private InlineMorph() {
    }

    public static InlineMorph in(Object owner) {
        return InlineMorph.in(owner.getClass());
    }

    public static InlineMorph in(Class<?> owner) {
        return new InlineMorph().setClassAsSystemId(owner);
    }

    private InlineMorph setClassAsSystemId(Class<?> owner) {
        URL baseUrl = owner.getResource("");
        this.systemId = baseUrl.toExternalForm();
        return this;
    }

    public InlineMorph with(String line) {
        if (this.scriptBuilder.length() == 0) {
            this.appendBoilerplate(line);
        }
        this.scriptBuilder.append(line).append("\n");
        return this;
    }

    private void appendBoilerplate(String line) {
        String trimmedLine = line.trim();
        if (!trimmedLine.startsWith("<?xml ")) {
            this.appendXmlBoilerplate();
            if (!trimmedLine.startsWith("<metamorph ")) {
                this.appendMetamorphBoilerplate();
                this.needFinishMetamorphBoilerplate = true;
            }
        }
    }

    private void appendXmlBoilerplate() {
        this.scriptBuilder.append(XML_BOILERPLATE);
    }

    private void appendMetamorphBoilerplate() {
        this.scriptBuilder.append(METAMORPH_BOILERPLATE);
    }

    public Metamorph create() {
        this.finishBoilerplate();
        return new Metamorph(this.createScriptSource());
    }

    private void finishBoilerplate() {
        if (this.needFinishMetamorphBoilerplate) {
            this.scriptBuilder.append(FINISH_METAMORPH_BOILERPLATE);
            this.needFinishMetamorphBoilerplate = false;
        }
    }

    private InputSource createScriptSource() {
        InputSource scriptSource = new InputSource();
        scriptSource.setSystemId(this.systemId);
        scriptSource.setCharacterStream(new StringReader(this.toString()));
        return scriptSource;
    }

    public String toString() {
        return this.scriptBuilder.toString() + (this.needFinishMetamorphBoilerplate ? FINISH_METAMORPH_BOILERPLATE : "");
    }

    public Metamorph createConnectedTo(StreamReceiver receiver) {
        Metamorph metamorph = this.create();
        metamorph.setReceiver(receiver);
        return metamorph;
    }
}

