/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.collectors;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.metafacture.metamorph.api.NamedValueSource;
import org.metafacture.metamorph.api.helpers.AbstractFlushingCollect;

public final class Range
extends AbstractFlushingCollect {
    private final SortedSet<Integer> values = new TreeSet<Integer>(new IncrementDependingComparator());
    private int increment;
    private Integer first;

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    protected void emit() {
        for (Integer i : this.values) {
            this.getNamedValueReceiver().receive(this.getName(), i.toString(), (NamedValueSource)this, this.getRecordCount(), this.getEntityCount());
        }
    }

    protected boolean isComplete() {
        return false;
    }

    protected void receive(String name, String value, NamedValueSource source) {
        if (this.first == null) {
            this.first = Integer.valueOf(value);
        } else {
            int last = Integer.valueOf(value);
            for (int i = this.first.intValue(); this.increment > 0 && i <= last || this.increment < 0 && i >= last; i += this.increment) {
                this.values.add(i);
            }
            this.first = null;
        }
    }

    protected void clear() {
        this.values.clear();
        this.first = null;
    }

    private class IncrementDependingComparator
    implements Comparator<Integer> {
        IncrementDependingComparator() {
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return Integer.signum(Range.this.increment) * (o1 - o2);
        }
    }
}

