/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.functions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.metafacture.metamorph.api.helpers.AbstractSimpleStatelessFunction;

public final class ISBN
extends AbstractSimpleStatelessFunction {
    public static final String ISBN10 = "isbn10";
    public static final String ISBN13 = "isbn13";
    private static final String CHECK = "0123456789X0";
    private static final Pattern ISBN_PATTERN = Pattern.compile("[\\dX]+");
    private static final Pattern DIRT_PATTERN = Pattern.compile("[\\.\\-]");
    private static final int ISBN10_SIZE = 10;
    private static final int ISBN10_MAGIC = 10;
    private static final int ISBN13_SIZE = 13;
    private static final int ISBN13_MAGIC = 3;
    private static final int ISBN10_MOD = 11;
    private static final int ISBN13_MOD = 10;
    private boolean to10;
    private boolean to13;
    private boolean verifyCheckDigit;
    private String errorString;

    public void setErrorString(String errorString) {
        this.errorString = errorString;
    }

    public String process(String value) {
        String result = ISBN.cleanse(value);
        int size = result.length();
        if (this.verifyCheckDigit && !ISBN.isValid(result)) {
            result = this.errorString;
        } else if (size != 10 && size != 13) {
            result = this.errorString;
        } else if (this.to10 && 13 == size) {
            result = ISBN.isbn13to10(result);
        } else if (this.to13 && 10 == size) {
            result = ISBN.isbn10to13(result);
        }
        return result;
    }

    public static String cleanse(String isbn) {
        String normValue = isbn.replace('x', 'X');
        Matcher matcher = ISBN_PATTERN.matcher(normValue = DIRT_PATTERN.matcher(normValue).replaceAll(""));
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }

    public void setTo(String toString) {
        this.to13 = toString.equalsIgnoreCase(ISBN13);
        this.to10 = toString.equalsIgnoreCase(ISBN10);
    }

    private static char check10(String isbn10Data) {
        assert (isbn10Data.length() == 9);
        int check = 0;
        for (int i = 0; i < 9; ++i) {
            int digit = ISBN.charToInt(isbn10Data.charAt(i));
            check += (10 - i) * digit;
        }
        check = 11 - check % 11;
        return CHECK.charAt(check);
    }

    private static char check13(String isbn13Data) {
        assert (isbn13Data.length() == 12);
        int accumulator = 0;
        for (int i = 0; i < 12; ++i) {
            int digit = ISBN.charToInt(isbn13Data.charAt(i));
            if (i % 2 == 0) {
                accumulator += digit;
                continue;
            }
            accumulator += 3 * digit;
        }
        if ((accumulator %= 10) != 0) {
            accumulator = 10 - accumulator;
        }
        return CHECK.charAt(accumulator);
    }

    private static int charToInt(char cha) {
        return (byte)cha - 48;
    }

    public static String isbn13to10(String isbn) {
        if (isbn.length() != 13) {
            throw new IllegalArgumentException("isbn must be 13 characters long");
        }
        String isbn10Data = isbn.substring(3, 12);
        return isbn10Data + ISBN.check10(isbn10Data);
    }

    public static String isbn10to13(String isbn) {
        if (isbn.length() != 10) {
            throw new IllegalArgumentException("isbn must be 10 characters long");
        }
        String isbn13Data = "978" + isbn.substring(0, 9);
        return isbn13Data + ISBN.check13(isbn13Data);
    }

    public static boolean isValid(String isbn) {
        boolean result = false;
        if (isbn.length() == 10) {
            result = ISBN.check10(isbn.substring(0, 9)) == isbn.charAt(9);
        } else if (isbn.length() == 13) {
            result = ISBN.check13(isbn.substring(0, 12)) == isbn.charAt(12);
        }
        return result;
    }

    public void setVerifyCheckDigit(String verifyCheckDigit) {
        this.verifyCheckDigit = "true".equals(verifyCheckDigit);
    }
}

