/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.functions;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.metafacture.commons.StringUtil;
import org.metafacture.metamorph.api.NamedValueSource;
import org.metafacture.metamorph.api.helpers.AbstractFunction;

public final class Regexp
extends AbstractFunction {
    private Matcher matcher;
    private String format;
    private final Map<String, String> tempVars = new HashMap<String, String>();

    public void receive(String name, String value, NamedValueSource source, int recordCount, int entityCount) {
        if (null == value) {
            return;
        }
        this.matcher.reset(value);
        if (null == this.format) {
            while (this.matcher.find()) {
                String group = this.matcher.group();
                if (group.isEmpty()) continue;
                this.getNamedValueReceiver().receive(name, group, (NamedValueSource)this, recordCount, entityCount);
            }
        } else {
            while (this.matcher.find()) {
                this.populateVars();
                if (this.tempVars.isEmpty()) continue;
                this.getNamedValueReceiver().receive(name, StringUtil.format((String)this.format, this.tempVars), (NamedValueSource)this, recordCount, entityCount);
            }
        }
    }

    private void populateVars() {
        this.tempVars.clear();
        for (int i = 0; i <= this.matcher.groupCount(); ++i) {
            String group = this.matcher.group(i);
            if (group == null || group.isEmpty()) continue;
            this.tempVars.put(String.valueOf(i), group);
        }
    }

    public void setMatch(String match) {
        this.matcher = Pattern.compile(match).matcher("");
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

