/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.functions;

import java.util.HashSet;
import java.util.Set;
import org.metafacture.metamorph.api.helpers.AbstractStatefulFunction;

public final class Unique
extends AbstractStatefulFunction {
    public static final String ENTITY = "entity";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    private final Set<String> set = new HashSet<String>();
    private boolean uniqueInEntity;
    private KeyGenerator keyGenerator = new KeyGenerator(){

        @Override
        public String createKey(String name, String value) {
            return name + "\u0000" + value;
        }
    };

    public String process(String value) {
        String key = this.keyGenerator.createKey(this.getLastName(), value);
        if (this.set.contains(key)) {
            return null;
        }
        this.set.add(key);
        return value;
    }

    protected void reset() {
        this.set.clear();
    }

    protected boolean doResetOnEntityChange() {
        return this.uniqueInEntity;
    }

    public void setIn(String scope) {
        this.uniqueInEntity = ENTITY.equals(scope);
    }

    public void setPart(String part) {
        if (NAME.equals(part)) {
            this.keyGenerator = new KeyGenerator(){

                @Override
                public String createKey(String name, String value) {
                    return name;
                }
            };
        } else if (VALUE.equals(part)) {
            this.keyGenerator = new KeyGenerator(){

                @Override
                public String createKey(String name, String value) {
                    return value;
                }
            };
        }
    }

    private static interface KeyGenerator {
        public String createKey(String var1, String var2);
    }
}

