/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.maps;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.metafacture.metamorph.api.MorphExecutionException;
import org.metafacture.metamorph.api.helpers.AbstractReadOnlyMap;

public final class JndiSqlMap
extends AbstractReadOnlyMap<String, String>
implements Closeable {
    private DataSource datasource;
    private String query;

    public void setDatasource(String name) {
        try {
            this.datasource = (DataSource)new InitialContext().lookup(name);
        }
        catch (NamingException e) {
            throw new MorphExecutionException("jndisqlmap: lookup of data source failed", (Throwable)e);
        }
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String get(Object key) {
        String resultString = null;
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.query);){
            statement.setString(1, key.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.first()) {
                    resultString = resultSet.getString(1);
                }
            }
        }
        catch (SQLException e) {
            throw new MorphExecutionException("jndisqlmap: execution of sql query failed", (Throwable)e);
        }
        return resultString;
    }

    @Override
    public void close() throws IOException {
    }
}

