/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.maps;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.metafacture.metamorph.api.MorphExecutionException;
import org.metafacture.metamorph.api.helpers.AbstractReadOnlyMap;

public final class SqlMap
extends AbstractReadOnlyMap<String, String>
implements Closeable {
    private boolean isUninitialized = true;
    private Connection conn;
    private String host;
    private String login;
    private String password;
    private String database;
    private String query;
    private String driver;
    private PreparedStatement preparedStatement;

    public void init() {
        try {
            this.preparedStatement = this.getMySqlConnection().prepareStatement(this.query);
        }
        catch (SQLException e) {
            throw new MorphExecutionException("sqlmap: could not create prepared statement for query", (Throwable)e);
        }
        this.isUninitialized = false;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            throw new MorphExecutionException("sqlmap: could not close db connection", (Throwable)e);
        }
    }

    private Connection getMySqlConnection() {
        try {
            Class.forName(this.driver);
            this.conn = DriverManager.getConnection("jdbc:mysql://" + this.host + "/" + this.database + "?user=" + this.login + "&password=" + this.password);
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new MorphExecutionException("sqlmap: cannot create db connection", (Throwable)e);
        }
        return this.conn;
    }

    public String get(Object key) {
        if (this.isUninitialized) {
            this.init();
        }
        String resultString = null;
        try {
            this.preparedStatement.setString(1, key.toString());
            ResultSet resultSet = this.preparedStatement.executeQuery();
            if (resultSet.first()) {
                resultString = resultSet.getString(1);
            }
            resultSet.close();
        }
        catch (SQLException e) {
            throw new MorphExecutionException("sqlmap: execution of prepared statement failed", (Throwable)e);
        }
        return resultString;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setQuery(String query) {
        this.query = query;
    }
}

