/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.xml;

import java.util.Deque;
import java.util.LinkedList;
import org.metafacture.metamorph.xml.Location;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;
import org.xml.sax.helpers.XMLFilterImpl;

final class LocationAnnotator
extends XMLFilterImpl {
    private static final String DOM_NODE_INSERTED = "DOMNodeInserted";
    private final Deque<Node> domNodes = new LinkedList<Node>();
    private final Deque<Locator> locatorsAtElementStart = new LinkedList<Locator>();
    private Locator locator;

    LocationAnnotator(XMLReader xmlReader, Document document) {
        super(xmlReader);
        EventListener listener = new EventListener(){

            @Override
            public void handleEvent(Event event) {
                Node node = (Node)((Object)event.getTarget());
                if (node.getNodeType() == 1) {
                    LocationAnnotator.this.domNodes.push(node);
                }
            }
        };
        ((EventTarget)((Object)document)).addEventListener(DOM_NODE_INSERTED, listener, true);
    }

    @Override
    public void setDocumentLocator(Locator newLocator) {
        super.setDocumentLocator(newLocator);
        this.locator = newLocator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(uri, localName, qName, atts);
        this.locatorsAtElementStart.push(new LocatorImpl(this.locator));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        Locator elementStartLocator = this.locatorsAtElementStart.pop();
        Location location = new Location(elementStartLocator, this.locator);
        Node domNode = this.domNodes.pop();
        domNode.setUserData("http://culturegraph.org/mf/user_data/location", location, Location.USER_DATA_HANDLER);
    }
}

