/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.metafacture.commons.StringUtil;
import org.metafacture.flowcontrol.StreamBuffer;
import org.metafacture.framework.Receiver;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.metamorph.Metamorph;
import org.metafacture.metamorph.api.NamedValueReceiver;
import org.metafacture.metamorph.api.NamedValueSource;
import org.metafacture.metamorph.api.helpers.AbstractFlushingCollect;

public final class Entity
extends AbstractFlushingCollect {
    private final List<NamedValueSource> sourceList = new ArrayList<NamedValueSource>();
    private final Set<NamedValueSource> sourcesLeft = new HashSet<NamedValueSource>();
    private final StreamBuffer buffer = new StreamBuffer();
    private final Supplier<StreamReceiver> receiver;
    private NamedValueSource nameSource;
    private String currentName;

    public Entity(Metamorph metamorph) {
        this.receiver = () -> metamorph.getStreamReceiver();
    }

    public Entity(Supplier<StreamReceiver> receiver) {
        this.receiver = receiver;
    }

    public void setNameSource(NamedValueSource source) {
        this.nameSource = source;
        this.nameSource.setNamedValueReceiver((NamedValueReceiver)this);
        this.onNamedValueSourceAdded(this.nameSource);
    }

    protected void emit() {
        NamedValueReceiver namedValueReceiver = this.getNamedValueReceiver();
        if (namedValueReceiver instanceof Entity) {
            Entity parent = (Entity)namedValueReceiver;
            parent.receive(null, null, (NamedValueSource)this, this.getRecordCount(), this.getEntityCount());
        } else {
            this.write(this.receiver.get());
        }
    }

    private void write(StreamReceiver currentReceiver) {
        if (!this.buffer.isEmpty()) {
            currentReceiver.startEntity((String)StringUtil.fallback((Object)this.currentName, (Object)this.getName()));
            this.buffer.setReceiver((Receiver)currentReceiver);
            this.buffer.replay();
            currentReceiver.endEntity();
        }
    }

    protected void receive(String name, String value, NamedValueSource source) {
        if (source == this.nameSource) {
            this.currentName = value;
        } else if (source instanceof Entity) {
            Entity child = (Entity)source;
            child.write((StreamReceiver)this.buffer);
        } else {
            this.buffer.literal(name, value);
        }
        this.sourcesLeft.remove(source);
    }

    protected boolean isComplete() {
        return this.sourcesLeft.isEmpty();
    }

    protected void clear() {
        this.sourcesLeft.addAll(this.sourceList);
        this.buffer.clear();
        this.currentName = null;
    }

    protected void onNamedValueSourceAdded(NamedValueSource namedValueSource) {
        this.sourceList.add(namedValueSource);
        this.sourcesLeft.add(namedValueSource);
    }
}

