/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.metafacture.commons.ResourceUtil;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.Receiver;
import org.metafacture.framework.StreamPipe;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamReceiver;
import org.metafacture.mangling.StreamFlattener;
import org.metafacture.metamorph.DefaultErrorHandler;
import org.metafacture.metamorph.MetamorphException;
import org.metafacture.metamorph.MorphBuilder;
import org.metafacture.metamorph.NullInterceptorFactory;
import org.metafacture.metamorph.Registry;
import org.metafacture.metamorph.WildcardRegistry;
import org.metafacture.metamorph.api.FlushListener;
import org.metafacture.metamorph.api.InterceptorFactory;
import org.metafacture.metamorph.api.Maps;
import org.metafacture.metamorph.api.MorphBuildException;
import org.metafacture.metamorph.api.MorphErrorHandler;
import org.metafacture.metamorph.api.NamedValuePipe;
import org.metafacture.metamorph.api.NamedValueReceiver;
import org.metafacture.metamorph.api.NamedValueSource;
import org.metafacture.metamorph.api.SourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

@Description(value="Applies a metamorph transformation to the event stream. Metamorph definition is given in brackets.")
@In(value=StreamReceiver.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="morph")
public final class Metamorph
implements StreamPipe<StreamReceiver>,
NamedValuePipe,
Maps {
    public static final String ELSE_KEYWORD = "_else";
    public static final String ELSE_NESTED_KEYWORD = "_elseNested";
    public static final String ELSE_FLATTENED_KEYWORD = "_elseFlattened";
    public static final char FEEDBACK_CHAR = '@';
    public static final char ESCAPE_CHAR = '\\';
    public static final String METADATA = "__meta";
    public static final String VAR_START = "$[";
    public static final String VAR_END = "]";
    private static final Logger LOG = LoggerFactory.getLogger(Metamorph.class);
    private static final String ENTITIES_NOT_BALANCED = "Entity starts and ends are not balanced";
    private static final String COULD_NOT_LOAD_MORPH_FILE = "Could not load morph file";
    private static final InterceptorFactory NULL_INTERCEPTOR_FACTORY = new NullInterceptorFactory();
    private static final Map<String, String> NO_VARS = Collections.emptyMap();
    private final Registry<NamedValueReceiver> dataRegistry = new WildcardRegistry<NamedValueReceiver>();
    private final List<NamedValueReceiver> elseSources = new ArrayList<NamedValueReceiver>();
    private final Map<String, Map<String, String>> maps = new HashMap<String, Map<String, String>>();
    private final List<Closeable> resources = new ArrayList<Closeable>();
    private final StreamFlattener flattener = new StreamFlattener();
    private final Deque<Integer> entityCountStack = new LinkedList<Integer>();
    private int entityCount;
    private int currentEntityCount;
    private StreamReceiver outputStreamReceiver;
    private MorphErrorHandler errorHandler = new DefaultErrorHandler();
    private int recordCount;
    private final List<FlushListener> recordEndListener = new ArrayList<FlushListener>();
    private final Deque<EntityEntry> elseNestedEntities = new LinkedList<EntityEntry>();
    private boolean elseNested;
    private String currentLiteralName;

    protected Metamorph() {
        this.init();
    }

    public Metamorph(String morphDef) {
        this(morphDef, NO_VARS);
    }

    public Metamorph(String morphDef, Map<String, String> vars) {
        this(morphDef, vars, NULL_INTERCEPTOR_FACTORY);
    }

    public Metamorph(String morphDef, InterceptorFactory interceptorFactory) {
        this(morphDef, NO_VARS, interceptorFactory);
    }

    public Metamorph(String morphDef, Map<String, String> vars, InterceptorFactory interceptorFactory) {
        this(Metamorph.getInputSource(morphDef), vars, interceptorFactory);
    }

    public Metamorph(Reader morphDef) {
        this(morphDef, NO_VARS);
    }

    public Metamorph(Reader morphDef, Map<String, String> vars) {
        this(morphDef, vars, NULL_INTERCEPTOR_FACTORY);
    }

    public Metamorph(Reader morphDef, InterceptorFactory interceptorFactory) {
        this(morphDef, NO_VARS, interceptorFactory);
    }

    public Metamorph(Reader morphDef, Map<String, String> vars, InterceptorFactory interceptorFactory) {
        this(new InputSource(morphDef), vars, interceptorFactory);
    }

    public Metamorph(InputStream morphDef) {
        this(morphDef, NO_VARS);
    }

    public Metamorph(InputStream morphDef, Map<String, String> vars) {
        this(morphDef, vars, NULL_INTERCEPTOR_FACTORY);
    }

    public Metamorph(InputStream morphDef, InterceptorFactory interceptorFactory) {
        this(morphDef, NO_VARS, interceptorFactory);
    }

    public Metamorph(InputStream morphDef, Map<String, String> vars, InterceptorFactory interceptorFactory) {
        this(new InputSource(morphDef), vars, interceptorFactory);
    }

    public Metamorph(InputSource inputSource) {
        this(inputSource, NO_VARS);
    }

    public Metamorph(InputSource inputSource, Map<String, String> vars) {
        this(inputSource, vars, NULL_INTERCEPTOR_FACTORY);
    }

    public Metamorph(InputSource inputSource, InterceptorFactory interceptorFactory) {
        this(inputSource, NO_VARS, interceptorFactory);
    }

    public Metamorph(InputSource inputSource, Map<String, String> vars, InterceptorFactory interceptorFactory) {
        this.buildPipeline(inputSource, vars, interceptorFactory);
        this.init();
    }

    private void buildPipeline(InputSource inputSource, Map<String, String> vars, InterceptorFactory interceptorFactory) {
        try {
            MorphBuilder builder = new MorphBuilder(this, interceptorFactory);
            builder.walk(inputSource, vars);
        }
        catch (RuntimeException e) {
            throw new MetamorphException("Error while building the Metamorph transformation pipeline: " + e.getMessage(), e);
        }
    }

    private static InputSource getInputSource(String morphDef) {
        try {
            return new InputSource(ResourceUtil.getUrl((String)morphDef).toExternalForm());
        }
        catch (MalformedURLException e) {
            throw new MorphBuildException(COULD_NOT_LOAD_MORPH_FILE, (Throwable)e);
        }
    }

    private void init() {
        this.flattener.setReceiver((Receiver)new DefaultStreamReceiver(){

            public void literal(String name, String value) {
                Metamorph.this.dispatch(name, value, Metamorph.this.getElseSources(), false);
            }
        });
    }

    protected List<NamedValueReceiver> getElseSources() {
        return this.elseSources;
    }

    protected void setEntityMarker(String entityMarker) {
        this.flattener.setEntityMarker(entityMarker);
    }

    public void setErrorHandler(MorphErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected void registerNamedValueReceiver(String source, NamedValueReceiver data) {
        if (ELSE_NESTED_KEYWORD.equals(source)) {
            this.elseNested = true;
        }
        if (ELSE_KEYWORD.equals(source) || ELSE_FLATTENED_KEYWORD.equals(source) || this.elseNested) {
            if (this.elseSources.isEmpty()) {
                this.elseSources.add(data);
            } else {
                LOG.warn("Only one of '_else', '_elseFlattened' and '_elseNested' is allowed. Ignoring the superflous ones.");
            }
        } else {
            this.dataRegistry.register(source, data);
        }
    }

    public void startRecord(String identifier) {
        this.flattener.startRecord(identifier);
        this.elseNestedEntities.clear();
        this.entityCountStack.clear();
        this.entityCount = 0;
        this.currentEntityCount = 0;
        this.entityCountStack.push(this.entityCount);
        ++this.recordCount;
        this.recordCount %= Integer.MAX_VALUE;
        String identifierFinal = identifier;
        this.outputStreamReceiver.startRecord(identifierFinal);
        this.dispatch("_id", identifierFinal, null, false);
    }

    public void endRecord() {
        for (FlushListener listener : this.recordEndListener) {
            listener.flush(this.recordCount, this.currentEntityCount);
        }
        this.outputStreamReceiver.endRecord();
        this.flattener.endRecord();
        this.entityCountStack.pop();
        if (!this.elseNestedEntities.isEmpty() || !this.entityCountStack.isEmpty()) {
            throw new IllegalStateException(ENTITIES_NOT_BALANCED);
        }
    }

    public void startEntity(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Entity name must not be null.");
        }
        ++this.entityCount;
        this.currentEntityCount = this.entityCount;
        this.entityCountStack.push(this.entityCount);
        this.flattener.startEntity(name);
        this.elseNestedEntities.push(new EntityEntry(this.flattener));
    }

    public void endEntity() {
        this.dispatch(this.flattener.getCurrentPath(), "", this.getElseSources(), true);
        this.flattener.endEntity();
        this.elseNestedEntities.pop();
        this.currentEntityCount = this.entityCountStack.pop();
    }

    public void literal(String name, String value) {
        this.currentLiteralName = name;
        this.flattener.literal(name, value);
    }

    public void resetStream() {
        this.outputStreamReceiver.resetStream();
    }

    public void closeStream() {
        for (Closeable closeable : this.resources) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.errorHandler.error((Exception)e);
            }
        }
        this.outputStreamReceiver.closeStream();
    }

    private void dispatch(String path, String value, List<NamedValueReceiver> fallbackReceiver, boolean endEntity) {
        List<NamedValueReceiver> matchingData = this.getData(path);
        if (matchingData != null) {
            this.send(path, value, matchingData);
        } else if (fallbackReceiver != null) {
            this.dispatchFallback(path, endEntity, k -> this.send(this.escapeFeedbackChar((String)k), value, fallbackReceiver));
        }
    }

    private void dispatchFallback(String path, boolean endEntity, Consumer<String> consumer) {
        EntityEntry entityEntry;
        EntityEntry entityEntry2 = entityEntry = this.elseNested ? this.elseNestedEntities.peek() : null;
        if (endEntity) {
            if (entityEntry != null && entityEntry.getStarted()) {
                this.outputStreamReceiver.endEntity();
            }
        } else if (entityEntry != null) {
            if (this.getData(entityEntry.getPath()) == null) {
                LinkedList<String> entities = new LinkedList<String>();
                for (EntityEntry e : this.elseNestedEntities) {
                    if (e.getStarted()) break;
                    e.setStarted(true);
                    entities.push(e.getName());
                }
                entities.forEach(arg_0 -> ((StreamReceiver)this.outputStreamReceiver).startEntity(arg_0));
                consumer.accept(this.currentLiteralName);
            }
        } else {
            consumer.accept(path);
        }
    }

    private List<NamedValueReceiver> getData(String path) {
        List<NamedValueReceiver> matchingData = this.dataRegistry.get(path);
        return matchingData != null && !matchingData.isEmpty() ? matchingData : null;
    }

    private void send(String path, String value, List<NamedValueReceiver> dataList) {
        for (NamedValueReceiver data : dataList) {
            try {
                data.receive(path, value, null, this.recordCount, this.currentEntityCount);
            }
            catch (RuntimeException e) {
                this.errorHandler.error((Exception)e);
            }
        }
    }

    private boolean startsWithFeedbackChar(String name) {
        return name.length() != 0 && name.charAt(0) == '@';
    }

    private String escapeFeedbackChar(String name) {
        return name == null ? null : (this.startsWithFeedbackChar(name) ? Character.valueOf('\\') : "") + name;
    }

    public <R extends StreamReceiver> R setReceiver(R streamReceiver) {
        if (streamReceiver == null) {
            throw new IllegalArgumentException("'streamReceiver' must not be null");
        }
        this.outputStreamReceiver = streamReceiver;
        return streamReceiver;
    }

    public StreamReceiver getStreamReceiver() {
        return this.outputStreamReceiver;
    }

    public void receive(String name, String value, NamedValueSource source, int unusedRecordCount, int unusedEntityCount) {
        if (null == name) {
            throw new IllegalArgumentException("encountered literal with name='null'. This indicates a bug in a function or a collector.");
        }
        if (this.startsWithFeedbackChar(name)) {
            this.dispatch(name, value, null, false);
            return;
        }
        String unescapedName = name;
        if (name.length() > 1 && name.charAt(0) == '\\' && (name.charAt(1) == '@' || name.charAt(1) == '\\')) {
            unescapedName = name.substring(1);
        }
        this.outputStreamReceiver.literal(unescapedName, value);
    }

    public Map<String, String> getMap(String mapName) {
        return this.maps.getOrDefault(mapName, Collections.emptyMap());
    }

    public String getValue(String mapName, String key) {
        Map<String, String> map = this.getMap(mapName);
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return map.get("__default");
    }

    public Map<String, String> putMap(String mapName, Map<String, String> map) {
        if (map instanceof Closeable) {
            Closeable closable = (Closeable)((Object)map);
            this.resources.add(closable);
        }
        return this.maps.put(mapName, map);
    }

    public String putValue(String mapName, String key, String value) {
        return this.maps.computeIfAbsent(mapName, k -> new HashMap()).put(key, value);
    }

    public Collection<String> getMapNames() {
        return Collections.unmodifiableSet(this.maps.keySet());
    }

    public void registerRecordEndFlush(FlushListener flushListener) {
        this.recordEndListener.add(flushListener);
    }

    public void addNamedValueSource(NamedValueSource namedValueSource) {
        namedValueSource.setNamedValueReceiver((NamedValueReceiver)this);
    }

    public void setNamedValueReceiver(NamedValueReceiver receiver) {
        throw new UnsupportedOperationException("The Metamorph object cannot act as a NamedValueSender");
    }

    public void setSourceLocation(SourceLocation sourceLocation) {
    }

    public SourceLocation getSourceLocation() {
        return null;
    }

    private static class EntityEntry {
        private final String name;
        private final String path;
        private boolean started;

        EntityEntry(StreamFlattener flattener) {
            this.name = flattener.getCurrentEntityName();
            this.path = flattener.getCurrentPath();
        }

        private String getName() {
            return this.name;
        }

        private String getPath() {
            return this.path;
        }

        private void setStarted(boolean started) {
            this.started = started;
        }

        private boolean getStarted() {
            return this.started;
        }
    }
}

