/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.collectors;

import java.util.HashMap;
import java.util.Map;
import org.metafacture.commons.StringUtil;
import org.metafacture.metamorph.api.NamedValueSource;
import org.metafacture.metamorph.api.helpers.AbstractFlushingCollect;

public final class Choose
extends AbstractFlushingCollect {
    private String value;
    private String name;
    private int priority = Integer.MAX_VALUE;
    private final Map<NamedValueSource, Integer> priorities = new HashMap<NamedValueSource, Integer>();
    private int nextPriority;

    protected void emit() {
        if (!this.isEmpty()) {
            this.getNamedValueReceiver().receive((String)StringUtil.fallback((Object)this.getName(), (Object)this.name), (String)StringUtil.fallback((Object)this.getValue(), (Object)this.value), (NamedValueSource)this, this.getRecordCount(), this.getEntityCount());
        }
    }

    private boolean isEmpty() {
        return this.name == null;
    }

    protected boolean isComplete() {
        return false;
    }

    protected void clear() {
        this.value = null;
        this.name = null;
        this.priority = Integer.MAX_VALUE;
    }

    protected void receive(String newName, String newValue, NamedValueSource source) {
        int sourcePriority = this.priorities.get(source);
        if (sourcePriority <= this.priority) {
            this.name = newName;
            this.value = newValue;
            this.priority = sourcePriority;
        }
    }

    protected void onNamedValueSourceAdded(NamedValueSource namedValueSource) {
        this.priorities.put(namedValueSource, this.nextPriority);
        ++this.nextPriority;
    }
}

