/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.maps;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.metafacture.io.FileOpener;
import org.metafacture.metamorph.api.MorphExecutionException;
import org.metafacture.metamorph.api.helpers.AbstractReadOnlyMap;

public final class FileMap
extends AbstractReadOnlyMap<String, String> {
    private final FileOpener fileOpener = new FileOpener();
    private final Map<String, String> map = new HashMap<String, String>();
    private Pattern split = Pattern.compile("\t", 16);
    private boolean allowEmptyValues;
    private boolean isUninitialized = true;
    private ArrayList<String> filenames = new ArrayList();

    private void init() {
        this.loadFiles();
        this.isUninitialized = false;
    }

    public void setAllowEmptyValues(boolean allowEmptyValues) {
        this.allowEmptyValues = allowEmptyValues;
    }

    public void setFiles(String files) {
        Collections.addAll(this.filenames, files.split("\\s*,\\s*"));
    }

    public void setFile(String file) {
        Collections.addAll(this.filenames, file);
    }

    public void setEncoding(String encoding) {
        this.fileOpener.setEncoding(encoding);
    }

    public void setCompression(String compression) {
        this.fileOpener.setCompression(compression);
    }

    public void setDecompressConcatenated(boolean decompressConcatenated) {
        this.fileOpener.setDecompressConcatenated(decompressConcatenated);
    }

    private void loadFiles() {
        this.filenames.forEach(this::loadFile);
    }

    private void loadFile(String file) {
        try (InputStream stream = this.openStream(file);
             Reader reader = this.fileOpener.open(stream);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                String[] parts;
                if (line.isEmpty() || (parts = this.allowEmptyValues ? this.split.split(line, -1) : this.split.split(line)).length != 2) continue;
                this.map.put(parts[0], parts[1]);
            }
        }
        catch (IOException | UncheckedIOException e) {
            throw new MorphExecutionException("filemap: cannot read map file", (Throwable)e);
        }
    }

    private InputStream openStream(String file) {
        return this.openAsFile(file).orElseGet(() -> this.openAsResource(file).orElseGet(() -> this.openAsUrl(file).orElseThrow(() -> new MorphExecutionException("File not found: " + file))));
    }

    private Optional<InputStream> openAsFile(String file) {
        try {
            return Optional.of(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
    }

    private Optional<InputStream> openAsResource(String file) {
        return Optional.ofNullable(Thread.currentThread().getContextClassLoader().getResourceAsStream(file));
    }

    private Optional<InputStream> openAsUrl(String file) {
        URL url;
        try {
            url = new URL(file);
        }
        catch (MalformedURLException e) {
            return Optional.empty();
        }
        try {
            return Optional.of(url.openStream());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void setSeparator(String delimiter) {
        this.split = Pattern.compile(delimiter, 16);
    }

    public String get(Object key) {
        if (this.isUninitialized) {
            this.init();
        }
        return this.map.get(key);
    }

    public Set<String> keySet() {
        if (this.isUninitialized) {
            this.init();
        }
        return Collections.unmodifiableSet(this.map.keySet());
    }
}

