/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import org.metafacture.commons.reflection.ConfigurableClass;
import org.metafacture.commons.reflection.ReflectionUtil;
import org.metafacture.metamorph.AbstractMetamorphDomWalker;
import org.metafacture.metamorph.Data;
import org.metafacture.metamorph.Entity;
import org.metafacture.metamorph.Flush;
import org.metafacture.metamorph.Metamorph;
import org.metafacture.metamorph.XmlSourceLocation;
import org.metafacture.metamorph.api.Collect;
import org.metafacture.metamorph.api.ConditionAware;
import org.metafacture.metamorph.api.FlushListener;
import org.metafacture.metamorph.api.Function;
import org.metafacture.metamorph.api.InterceptorFactory;
import org.metafacture.metamorph.api.Maps;
import org.metafacture.metamorph.api.MorphBuildException;
import org.metafacture.metamorph.api.NamedValuePipe;
import org.metafacture.metamorph.api.NamedValueReceiver;
import org.metafacture.metamorph.api.NamedValueSource;
import org.metafacture.metamorph.api.SourceLocation;
import org.metafacture.metamorph.xml.Location;
import org.w3c.dom.Node;

public final class MorphBuilder
extends AbstractMetamorphDomWalker {
    private static final String NOT_FOUND = " not found.";
    private static final String JAVA = "java";
    private static final String JAVAMAP = "javamap";
    private static final String RECORD = "record";
    private static final String OR_STRING = "|";
    private static final Pattern OR_PATTERN = Pattern.compile("|", 16);
    private final Metamorph metamorph;
    private final InterceptorFactory interceptorFactory;
    private final Deque<StackFrame> stack = new LinkedList<StackFrame>();

    protected MorphBuilder(Metamorph metamorph, InterceptorFactory interceptorFactory) {
        this.metamorph = metamorph;
        this.interceptorFactory = interceptorFactory;
        this.stack.push(new StackFrame(metamorph));
    }

    @Override
    protected void setEntityMarker(String entityMarker) {
        if (null != entityMarker) {
            this.metamorph.setEntityMarker(entityMarker);
        }
    }

    @Override
    protected void handleInternalMap(Node mapNode) {
        String mapName = this.resolvedAttribute(mapNode, AbstractMetamorphDomWalker.AttributeName.NAME);
        String mapDefault = this.resolvedAttribute(mapNode, AbstractMetamorphDomWalker.AttributeName.DEFAULT);
        for (Node entryNode = mapNode.getFirstChild(); entryNode != null; entryNode = entryNode.getNextSibling()) {
            String entryName = this.resolvedAttribute(entryNode, AbstractMetamorphDomWalker.AttributeName.NAME);
            String entryValue = this.resolvedAttribute(entryNode, AbstractMetamorphDomWalker.AttributeName.VALUE);
            this.metamorph.putValue(mapName, entryName, entryValue);
        }
        if (mapDefault != null) {
            this.metamorph.putValue(mapName, "__default", mapDefault);
        }
    }

    @Override
    protected void handleMapClass(Node mapNode) {
        Map map;
        Map<String, String> attributes = this.resolvedAttributeMap(mapNode);
        String mapName = this.resolveVars(attributes.remove(AbstractMetamorphDomWalker.AttributeName.NAME.getString()));
        if (mapNode.getLocalName().equals(JAVAMAP)) {
            String className = this.resolvedAttribute(mapNode, AbstractMetamorphDomWalker.AttributeName.CLASS);
            attributes.remove(AbstractMetamorphDomWalker.AttributeName.CLASS.getString());
            ConfigurableClass mapClass = ReflectionUtil.loadClass((String)className, Map.class);
            map = (Map)mapClass.newInstance(attributes, new Object[0]);
        } else if (this.getMapFactory().containsKey(mapNode.getLocalName())) {
            map = (Map)this.getMapFactory().newInstance(mapNode.getLocalName(), attributes, new Object[0]);
        } else {
            throw new MorphBuildException("Map " + mapNode.getLocalName() + NOT_FOUND);
        }
        this.metamorph.putMap(mapName, map);
    }

    @Override
    protected void handleFunctionDefinition(Node functionDefNode) {
        Class<?> clazz;
        String className = this.resolvedAttribute(functionDefNode, AbstractMetamorphDomWalker.AttributeName.CLASS);
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new MorphBuildException("Function " + className + NOT_FOUND, (Throwable)e);
        }
        if (!Function.class.isAssignableFrom(clazz)) {
            throw new MorphBuildException(className + " does not implement interface 'Function'");
        }
        this.getFunctionFactory().registerClass(this.resolvedAttribute(functionDefNode, AbstractMetamorphDomWalker.AttributeName.NAME), clazz);
    }

    @Override
    protected void handleMetaEntry(String name, String value) {
        this.metamorph.putValue("__meta", name, value);
    }

    @Override
    protected void init() {
    }

    @Override
    protected void finish() {
    }

    @Override
    protected void enterData(Node dataNode) {
        Data delegate;
        Data data = new Data();
        data.setName(this.resolvedAttribute(dataNode, AbstractMetamorphDomWalker.AttributeName.NAME));
        data.setSourceLocation(this.getSourceLocation(dataNode));
        NamedValuePipe interceptor = this.interceptorFactory.createNamedValueInterceptor();
        if (interceptor == null) {
            delegate = data;
        } else {
            delegate = interceptor;
            data.addNamedValueSource((NamedValueSource)delegate);
        }
        String source = this.resolvedAttribute(dataNode, AbstractMetamorphDomWalker.AttributeName.SOURCE);
        this.metamorph.registerNamedValueReceiver(source, (NamedValueReceiver)delegate);
        this.stack.push(new StackFrame((NamedValuePipe)data));
    }

    @Override
    protected void exitData(Node node) {
        NamedValuePipe delegate;
        NamedValuePipe dataPipe = this.stack.pop().getPipe();
        NamedValuePipe interceptor = this.interceptorFactory.createNamedValueInterceptor();
        if (interceptor == null) {
            delegate = dataPipe;
        } else {
            delegate = interceptor;
            delegate.addNamedValueSource((NamedValueSource)dataPipe);
        }
        StackFrame parent = this.stack.peek();
        if (parent.isInEntityName()) {
            ((Entity)parent.getPipe()).setNameSource((NamedValueSource)delegate);
        } else if (parent.isInCondition()) {
            ((ConditionAware)parent.getPipe()).setConditionSource((NamedValueSource)delegate);
        } else {
            parent.getPipe().addNamedValueSource((NamedValueSource)delegate);
        }
    }

    @Override
    protected void enterName(Node nameNode) {
        assert (this.stack.peek().getPipe() instanceof Entity) : "statement `name` is only allowed in `entity` statements";
        this.stack.peek().setInEntityName(true);
    }

    @Override
    protected void exitName(Node nameNode) {
        this.stack.peek().setInEntityName(false);
    }

    @Override
    protected void enterIf(Node nameNode) {
        assert (this.stack.peek().getPipe() instanceof ConditionAware) : "statement `if` is not allowed in the current element";
        this.stack.peek().setInCondition(true);
    }

    @Override
    protected void exitIf(Node nameNode) {
        this.stack.peek().setInCondition(false);
    }

    @Override
    protected void enterCollect(Node node) {
        Map<String, String> attributes = this.resolvedAttributeMap(node);
        attributes.remove(AbstractMetamorphDomWalker.AttributeName.FLUSH_WITH.getString());
        if (!this.getCollectFactory().containsKey(node.getLocalName())) {
            throw new MorphBuildException("Collector " + node.getLocalName() + NOT_FOUND);
        }
        Collect collect = "entity".equals(node.getLocalName()) ? (Collect)this.getCollectFactory().newInstance(node.getLocalName(), attributes, new Object[]{this.metamorph}) : (Collect)this.getCollectFactory().newInstance(node.getLocalName(), attributes, new Object[0]);
        collect.setSourceLocation((SourceLocation)this.getSourceLocation(node));
        this.stack.push(new StackFrame((NamedValuePipe)collect));
    }

    @Override
    protected void exitCollect(Node node) {
        NamedValuePipe delegate;
        StackFrame currentCollect = this.stack.pop();
        Collect collector = (Collect)currentCollect.getHeadPipe();
        NamedValuePipe tailPipe = currentCollect.getPipe();
        NamedValuePipe interceptor = this.interceptorFactory.createNamedValueInterceptor();
        if (interceptor == null || tailPipe instanceof Entity) {
            delegate = tailPipe;
        } else {
            delegate = interceptor;
            delegate.addNamedValueSource((NamedValueSource)tailPipe);
        }
        StackFrame parent = this.stack.peek();
        if (parent.isInEntityName()) {
            ((Entity)parent.getPipe()).setNameSource((NamedValueSource)delegate);
        } else if (parent.isInCondition()) {
            ((ConditionAware)parent.getPipe()).setConditionSource((NamedValueSource)delegate);
        } else {
            parent.getPipe().addNamedValueSource((NamedValueSource)delegate);
        }
        String flushWith = this.resolvedAttribute(node, AbstractMetamorphDomWalker.AttributeName.FLUSH_WITH);
        if (null != flushWith) {
            collector.setWaitForFlush(true);
            this.registerFlush(flushWith, (FlushListener)collector);
        }
    }

    private void registerFlush(String flushWith, FlushListener flushListener) {
        String[] keysSplit;
        for (String key : keysSplit = OR_PATTERN.split(flushWith)) {
            FlushListener interceptor = this.interceptorFactory.createFlushInterceptor(flushListener);
            FlushListener delegate = interceptor == null ? flushListener : interceptor;
            if (key.equals(RECORD)) {
                this.metamorph.registerRecordEndFlush(delegate);
                continue;
            }
            this.metamorph.registerNamedValueReceiver(key, new Flush(delegate));
        }
    }

    @Override
    protected void handleFunction(Node functionNode) {
        Function delegate;
        Function function;
        Map<String, String> attributes = this.resolvedAttributeMap(functionNode);
        if (functionNode.getLocalName().equals(JAVA)) {
            String className = this.resolvedAttribute(functionNode, AbstractMetamorphDomWalker.AttributeName.CLASS);
            attributes.remove(AbstractMetamorphDomWalker.AttributeName.CLASS.getString());
            ConfigurableClass functionClass = ReflectionUtil.loadClass((String)className, Function.class);
            function = (Function)functionClass.newInstance(attributes, new Object[0]);
        } else if (this.getFunctionFactory().containsKey(functionNode.getLocalName())) {
            String flushWith = attributes.remove(AbstractMetamorphDomWalker.AttributeName.FLUSH_WITH.getString());
            function = (Function)this.getFunctionFactory().newInstance(functionNode.getLocalName(), attributes, new Object[0]);
            if (null != flushWith) {
                this.registerFlush(flushWith, (FlushListener)function);
            }
        } else {
            throw new MorphBuildException(functionNode.getLocalName() + NOT_FOUND);
        }
        function.setSourceLocation((SourceLocation)this.getSourceLocation(functionNode));
        function.setMaps((Maps)this.metamorph);
        for (Node mapEntryNode = functionNode.getFirstChild(); mapEntryNode != null; mapEntryNode = mapEntryNode.getNextSibling()) {
            String entryName = this.resolvedAttribute(mapEntryNode, AbstractMetamorphDomWalker.AttributeName.NAME);
            String entryValue = this.resolvedAttribute(mapEntryNode, AbstractMetamorphDomWalker.AttributeName.VALUE);
            function.putValue(entryName, entryValue);
        }
        StackFrame head = this.stack.peek();
        NamedValuePipe interceptor = this.interceptorFactory.createNamedValueInterceptor();
        if (interceptor == null) {
            delegate = function;
        } else {
            delegate = interceptor;
            function.addNamedValueSource((NamedValueSource)delegate);
        }
        delegate.addNamedValueSource((NamedValueSource)head.getPipe());
        head.setPipe((NamedValuePipe)function);
    }

    private XmlSourceLocation getSourceLocation(Node node) {
        return new XmlSourceLocation((Location)node.getUserData("http://culturegraph.org/mf/user_data/location"));
    }

    private static final class StackFrame {
        private final NamedValuePipe headPipe;
        private NamedValuePipe pipe;
        private boolean inEntityName;
        private boolean inCondition;

        StackFrame(NamedValuePipe headPipe) {
            this.headPipe = headPipe;
            this.pipe = headPipe;
        }

        public NamedValuePipe getHeadPipe() {
            return this.headPipe;
        }

        public void setPipe(NamedValuePipe pipe) {
            this.pipe = pipe;
        }

        public NamedValuePipe getPipe() {
            return this.pipe;
        }

        public void setInEntityName(boolean inEntityName) {
            this.inEntityName = inEntityName;
        }

        public boolean isInEntityName() {
            return this.inEntityName;
        }

        public void setInCondition(boolean inCondition) {
            this.inCondition = inCondition;
        }

        public boolean isInCondition() {
            return this.inCondition;
        }
    }
}

