/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.metafacture.flowcontrol.StreamBuffer;
import org.metafacture.framework.Receiver;
import org.metafacture.framework.StreamPipe;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.javaintegration.SingleValue;
import org.metafacture.metamorph.Metamorph;

@Description(value="Splits a stream based on a morph definition")
@In(value=StreamReceiver.class)
@Out(value=StreamReceiver.class)
public final class Splitter
implements StreamPipe<StreamReceiver> {
    private final StreamBuffer buffer = new StreamBuffer();
    private final SingleValue singleValue = new SingleValue();
    private final Map<String, StreamReceiver> receiverMap = new HashMap<String, StreamReceiver>();
    private final Metamorph metamorph;

    public Splitter(String morphDef) {
        this.metamorph = new Metamorph(morphDef);
        this.metamorph.setReceiver(this.singleValue);
    }

    public Splitter(Reader morphDef) {
        this.metamorph = new Metamorph(morphDef);
        this.metamorph.setReceiver(this.singleValue);
    }

    public Splitter(Metamorph metamorph) {
        this.metamorph = metamorph;
        metamorph.setReceiver(this.singleValue);
    }

    public <R extends StreamReceiver> R setReceiver(R receiver) {
        this.receiverMap.put("", receiver);
        return receiver;
    }

    public <R extends StreamReceiver> R setReceiver(String key, R receiver) {
        this.receiverMap.put(key, receiver);
        return receiver;
    }

    private void dispatch() {
        String key = this.singleValue.getValue();
        StreamReceiver receiver = this.receiverMap.get(key);
        if (null != receiver) {
            this.buffer.setReceiver((Receiver)receiver);
            this.buffer.replay();
        }
        this.buffer.clear();
    }

    public void startRecord(String identifier) {
        this.buffer.startRecord(identifier);
        this.metamorph.startRecord(identifier);
    }

    public void endRecord() {
        this.buffer.endRecord();
        this.metamorph.endRecord();
        this.dispatch();
    }

    public void startEntity(String name) {
        this.buffer.startEntity(name);
        this.metamorph.startEntity(name);
    }

    public void endEntity() {
        this.buffer.endEntity();
        this.metamorph.endEntity();
    }

    public void literal(String name, String value) {
        this.buffer.literal(name, value);
        this.metamorph.literal(name, value);
    }

    public void resetStream() {
        this.buffer.clear();
        this.metamorph.resetStream();
        for (StreamReceiver receiver : this.receiverMap.values()) {
            receiver.resetStream();
        }
    }

    public void closeStream() {
        this.buffer.clear();
        this.metamorph.closeStream();
        for (StreamReceiver receiver : this.receiverMap.values()) {
            receiver.closeStream();
        }
    }
}

