/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph;

import org.metafacture.metamorph.api.SourceLocation;
import org.metafacture.metamorph.xml.Location;

final class XmlSourceLocation
implements SourceLocation {
    private final Location location;

    XmlSourceLocation(Location location) {
        this.location = location;
    }

    public String getFileName() {
        return this.location.getSystemId();
    }

    public SourceLocation.Position getStartPosition() {
        return new SourceLocation.Position(){

            public int getLineNumber() {
                return XmlSourceLocation.this.location.getElementStart().getLineNumber();
            }

            public int getColumnNumber() {
                return XmlSourceLocation.this.location.getElementStart().getColumnNumber();
            }
        };
    }

    public SourceLocation.Position getEndPosition() {
        return new SourceLocation.Position(){

            public int getLineNumber() {
                return XmlSourceLocation.this.location.getElementEnd().getLineNumber();
            }

            public int getColumnNumber() {
                return XmlSourceLocation.this.location.getElementEnd().getColumnNumber();
            }
        };
    }

    public String toString() {
        return this.location.toString();
    }
}

