/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.collectors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.metafacture.commons.StringUtil;
import org.metafacture.metamorph.api.NamedValueSource;
import org.metafacture.metamorph.api.helpers.AbstractFlushingCollect;

public final class Combine
extends AbstractFlushingCollect {
    private final Map<String, String> variables = new HashMap<String, String>();
    private final Set<NamedValueSource> sources = new HashSet<NamedValueSource>();
    private final Set<NamedValueSource> sourcesLeft = new HashSet<NamedValueSource>();

    protected void emit() {
        String name = StringUtil.format((String)this.getName(), this.variables);
        String value = StringUtil.format((String)this.getValue(), this.variables);
        this.getNamedValueReceiver().receive(name, value, (NamedValueSource)this, this.getRecordCount(), this.getEntityCount());
    }

    protected boolean isComplete() {
        return this.sourcesLeft.isEmpty();
    }

    protected void receive(String name, String value, NamedValueSource source) {
        this.variables.put(name, value);
        this.sourcesLeft.remove(source);
    }

    protected void onNamedValueSourceAdded(NamedValueSource namedValueSource) {
        this.sources.add(namedValueSource);
        this.sourcesLeft.add(namedValueSource);
    }

    protected void clear() {
        this.sourcesLeft.addAll(this.sources);
        this.variables.clear();
    }
}

