/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.functions;

import java.util.ArrayList;
import java.util.List;
import org.metafacture.metamorph.api.NamedValueReceiver;
import org.metafacture.metamorph.api.NamedValueSource;
import org.metafacture.metamorph.api.helpers.AbstractFunction;

public final class Buffer
extends AbstractFunction {
    private final List<Receipt> receipts = new ArrayList<Receipt>();
    private int currentRecord;

    public void receive(String name, String value, NamedValueSource source, int recordCount, int entityCount) {
        if (this.currentRecord != recordCount) {
            this.receipts.clear();
            this.currentRecord = recordCount;
        }
        this.receipts.add(new Receipt(name, value, (NamedValueSource)this, recordCount, entityCount));
    }

    public void flush(int recordCount, int entityCount) {
        for (Receipt receipt : this.receipts) {
            receipt.send(this.getNamedValueReceiver());
        }
        this.receipts.clear();
    }

    private static final class Receipt {
        private final String name;
        private final String value;
        private final NamedValueSource source;
        private final int recordCount;
        private final int entityCount;

        protected Receipt(String name, String value, NamedValueSource source, int recordCount, int entityCount) {
            this.name = name;
            this.value = value;
            this.source = source;
            this.recordCount = recordCount;
            this.entityCount = entityCount;
        }

        protected void send(NamedValueReceiver receiver) {
            receiver.receive(this.name, this.value, this.source, this.recordCount, this.entityCount);
        }
    }
}

