/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.functions;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.metafacture.metamorph.api.MorphBuildException;
import org.metafacture.metamorph.api.helpers.AbstractSimpleStatelessFunction;

public final class Case
extends AbstractSimpleStatelessFunction {
    public static final String UPPER = "upper";
    private static final Set<String> LANGUAGES;
    private Locale locale = Locale.getDefault();
    private boolean toUpper;

    public String process(String value) {
        if (this.toUpper) {
            return value.toUpperCase(this.locale);
        }
        return value.toLowerCase(this.locale);
    }

    public void setTo(String string) {
        this.toUpper = UPPER.equals(string);
    }

    public void setLanguage(String language) {
        if (!LANGUAGES.contains(language)) {
            throw new MorphBuildException("Language " + language + " not supported.");
        }
        this.locale = new Locale(language);
    }

    static {
        HashSet set = new HashSet();
        Collections.addAll(set, Locale.getISOLanguages());
        LANGUAGES = Collections.unmodifiableSet(set);
    }
}

