/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.functions;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.metafacture.metamorph.api.MorphBuildException;
import org.metafacture.metamorph.api.helpers.AbstractSimpleStatelessFunction;

public class DateFormat
extends AbstractSimpleStatelessFunction {
    public static final String DEFAULT_INPUT_FORMAT = "dd.MM.yyyy";
    public static final DateFormats DEFAULT_OUTPUT_FORMAT = DateFormats.LONG;
    public static final boolean DEFAULT_REMOVE_LEADING_ZEROS = false;
    public static final Era DEFAULT_ERA = Era.AUTO;
    private static final Set<String> SUPPORTED_LANGUAGES;
    private String inputFormat = "dd.MM.yyyy";
    private DateFormats outputFormat = DEFAULT_OUTPUT_FORMAT;
    private Era era = DEFAULT_ERA;
    private boolean removeLeadingZeros = false;
    private Locale outputLocale = Locale.getDefault();

    public final String process(String value) {
        String result;
        try {
            Calendar c = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat(this.inputFormat);
            c.setTime(sdf.parse(value));
            if (this.era == Era.BC) {
                c.set(0, 0);
            } else if (this.era == Era.AD) {
                c.set(0, 1);
            }
            SimpleDateFormat sdfp = (SimpleDateFormat)java.text.DateFormat.getDateInstance(this.outputFormat.getFormatId(), this.outputLocale);
            String p = sdfp.toPattern();
            if (c.get(0) == 0) {
                p = p.replace("yyyy", "yyyy G");
            }
            SimpleDateFormat sdfo = new SimpleDateFormat(p, this.outputLocale);
            result = sdfo.format(c.getTime());
            if (this.removeLeadingZeros) {
                result = result.replaceAll("([0]{1,})([0-9]{1,})", "$2");
            }
        }
        catch (IllegalArgumentException e) {
            throw new MorphBuildException("The date/time format is not supported.", (Throwable)e);
        }
        catch (Exception e) {
            result = value;
        }
        return result;
    }

    public final void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    public final void setOutputFormat(DateFormats outputFormat) {
        this.outputFormat = outputFormat;
    }

    public final void setEra(Era era) {
        this.era = era;
    }

    public final void setRemoveLeadingZeros(boolean removeLeadingZeros) {
        this.removeLeadingZeros = removeLeadingZeros;
    }

    public final void setLanguage(String language) {
        if (!SUPPORTED_LANGUAGES.contains(language)) {
            throw new MorphBuildException("Language '" + language + "' not supported.");
        }
        this.outputLocale = new Locale(language);
    }

    static {
        HashSet set = new HashSet();
        Collections.addAll(set, Locale.getISOLanguages());
        SUPPORTED_LANGUAGES = Collections.unmodifiableSet(set);
    }

    public static enum Era {
        AD(1),
        BC(0),
        AUTO(-1);

        private final int eraId;

        private Era(int eraId) {
            this.eraId = eraId;
        }

        int getEraId() {
            return this.eraId;
        }
    }

    public static enum DateFormats {
        FULL(0),
        LONG(1),
        MEDIUM(2),
        SHORT(3);

        private final int formatId;

        private DateFormats(int formatId) {
            this.formatId = formatId;
        }

        int getFormatId() {
            return this.formatId;
        }
    }
}

